/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class HttpToHttpsRedirectTest
extends AbstractBasicTest {
    private final AtomicBoolean isSet = new AtomicBoolean(false);

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port2);
        https_config.setOutputBufferSize(32768);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        SslContextFactory sslContextFactory = new SslContextFactory();
        ClassLoader cl = this.getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        this.log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keyStoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keyStoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        this.log.info("SSL keystore path: {}", (Object)keyStoreFile);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        connector.setHost("127.0.0.1");
        connector.setPort(this.port2);
        this.server.addConnector((Connector)connector);
        this.server.setHandler((Handler)new Relative302Handler());
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"standalone", "default_provider"})
    public void httpToHttpsRedirect() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setMaxRedirects(5).setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", this.getTargetUrl2()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-httpToHttps"), (String)"PASS");
        }
    }

    @Override
    public String getTargetUrl2() {
        return String.format("https://127.0.0.1:%d/foo/test", this.port2);
    }

    @Test(groups={"standalone", "default_provider"})
    public void httpToHttpsProperConfig() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setMaxRedirects(5).setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", this.getTargetUrl2() + "/test2").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-httpToHttps"), (String)"PASS");
            response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", this.getTargetUrl2() + "/foo2").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-httpToHttps"), (String)"PASS");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void relativeLocationUrl() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setMaxRedirects(5).setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", "/foo/test").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getUri().toString(), (String)this.getTargetUrl());
        }
    }

    private class Relative302Handler
    extends AbstractHandler {
        private Relative302Handler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setContentType("text/html; charset=utf-8");
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                if (!param.startsWith("X-redirect") || HttpToHttpsRedirectTest.this.isSet.getAndSet(true)) continue;
                httpResponse.addHeader("Location", httpRequest.getHeader(param));
                httpResponse.setStatus(302);
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
                return;
            }
            if (r.getScheme().equalsIgnoreCase("https")) {
                httpResponse.addHeader("X-httpToHttps", "PASS");
                HttpToHttpsRedirectTest.this.isSet.getAndSet(false);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

