/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import com.ning.http.client.cookie.RFC2616DateParser;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RFC2616DateParserTest {
    @Test(groups={"fast"})
    public void testRFC822() throws ParseException {
        Date date = RFC2616DateParser.get().parse("Sun, 06 Nov 1994 08:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"fast"})
    public void testRFC822SingleDigitDayOfMonth() throws ParseException {
        Date date = RFC2616DateParser.get().parse("Sun, 6 Nov 1994 08:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"fast"})
    public void testRFC822SingleDigitHour() throws ParseException {
        Date date = RFC2616DateParser.get().parse("Sun, 6 Nov 1994 8:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"fast"})
    public void testRFC850() throws ParseException {
        Date date = RFC2616DateParser.get().parse("Sunday, 06-Nov-94 08:49:37 GMT");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }

    @Test(groups={"fast"})
    public void testANSIC() throws ParseException {
        Date date = RFC2616DateParser.get().parse("Sun Nov  6 08:49:37 1994");
        Assert.assertNotNull((Object)date);
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        Assert.assertEquals((int)cal.get(7), (int)1);
        Assert.assertEquals((int)cal.get(5), (int)6);
        Assert.assertEquals((int)cal.get(2), (int)10);
        Assert.assertEquals((int)cal.get(1), (int)1994);
        Assert.assertEquals((int)cal.get(10), (int)8);
        Assert.assertEquals((int)cal.get(12), (int)49);
        Assert.assertEquals((int)cal.get(13), (int)37);
    }
}

