/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.ProviderUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicProxyAuthorizationTest
extends AbstractBasicTest {
    protected static final Logger log = LoggerFactory.getLogger(BasicProxyAuthorizationTest.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String CONNECTION_HEADER = "X-Connection";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return ProviderUtil.grizzlyProvider(config);
    }

    public HandlerWrapper configureHandler() throws Exception {
        return new BasicProxyAuthorizationHandler();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        Server server2 = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost(LOCALHOST);
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port2);
        https_config.setOutputBufferSize(32768);
        SslContextFactory sslContextFactory = new SslContextFactory();
        ClassLoader cl = this.getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keystoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keystoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        log.info("SSL keystore path: {}", (Object)trustStoreFile);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        ServerConnector connector = new ServerConnector(server2, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        connector.setHost(LOCALHOST);
        connector.setPort(this.port2);
        server2.addConnector((Connector)connector);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        server2.setHandler((Handler)new AbstractBasicTest.EchoHandler());
        server2.start();
        log.info("Local HTTP server started successfully");
    }

    @Test(description="W-10863931: When the connection is not an NTLM one, the NTLM proxy authorization is not required.")
    public void connectionProxyAuthorizationHeaderProperlySetTest() throws Throwable {
        ProxyServer proxyServer = new ProxyServer(LOCALHOST, this.port1);
        AsyncHttpClientConfig asyncHttpClientConfig = new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(asyncHttpClientConfig);){
            Request request = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl2()).setProxyServer(proxyServer)).build();
            Response response = (Response)client.executeRequest(request).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader(CONNECTION_HEADER), (String)KEEP_ALIVE);
        }
    }

    public static class BasicProxyAuthorizationHandler
    extends ConnectHandler {
        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            Assert.assertNull((Object)httpRequest.getHeader(BasicProxyAuthorizationTest.PROXY_AUTHORIZATION_HEADER));
            super.handle(pathInContext, request, httpRequest, httpResponse);
        }
    }
}

