/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class NTLMTest
extends AbstractBasicTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(NTLMTest.class);
    private static final Set<String> seenClients = new HashSet<String>();
    private static final Set<String> authenticatedClients = new HashSet<String>();
    private static final String PAYLOAD = "PAYLOAD";
    private AsyncHttpClient client;

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new NTLMHandler(false);
    }

    private Realm.RealmBuilder realmBuilderBase() {
        return new Realm.RealmBuilder().setScheme(Realm.AuthScheme.NTLM).setNtlmDomain("Ursa-Minor").setNtlmHost("LightCity").setPrincipal("Zaphod").setPassword("Beeblebrox");
    }

    private void ntlmAuthWithGetTest(Realm.RealmBuilder realmBuilder, int numReqs) throws IOException, InterruptedException, ExecutionException {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setRealm(realmBuilder.build()).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Request request = new RequestBuilder(HttpMethod.GET.asString()).setUrl(this.getTargetUrl()).build();
            for (int i = 0; i < numReqs; ++i) {
                ListenableFuture responseFuture = client.executeRequest(request);
                int status = ((Response)responseFuture.get()).getStatusCode();
                Assert.assertEquals((int)status, (int)200);
            }
        }
    }

    private void ntlmAuthTestWithPost(Realm.RealmBuilder realmBuilder, int numReqs) throws IOException, InterruptedException, ExecutionException {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setRealm(realmBuilder.build()).setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            ByteArrayInputStream body = new ByteArrayInputStream(PAYLOAD.getBytes());
            Request request = ((RequestBuilder)new RequestBuilder(HttpMethod.POST.asString()).setBody((BodyGenerator)new InputStreamBodyGenerator((InputStream)body))).setUrl(this.getTargetUrl()).setBody(PAYLOAD).build();
            for (int i = 0; i < numReqs; ++i) {
                ListenableFuture responseFuture = client.executeRequest(request);
                int status = ((Response)responseFuture.get()).getStatusCode();
                Assert.assertEquals((int)status, (int)200);
            }
        }
    }

    private Future<Response> makeNtlmAuthenticatedRequestWithCredentials(Realm.RealmBuilder realmBuilder) throws InterruptedException, ExecutionException, IOException {
        Request request = ((RequestBuilder)new RequestBuilder(HttpMethod.GET.asString()).setUrl(this.getTargetUrl()).setRealm(realmBuilder.build())).build();
        return this.client.executeRequest(request);
    }

    @BeforeMethod
    public void cleanTestWatchers() {
        seenClients.clear();
        authenticatedClients.clear();
    }

    @Test
    public void lazyNTLMAuthPostTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthTestWithPost(this.realmBuilderBase(), 1);
    }

    @Test
    public void preemptiveNTLMAuthPostTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthTestWithPost(this.realmBuilderBase().setUsePreemptiveAuth(true), 1);
    }

    @Test
    public void lazyNTLMAuthMultiplePostTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthTestWithPost(this.realmBuilderBase(), 3);
    }

    @Test
    public void preemptiveNTLMAuthMultiplePostTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthTestWithPost(this.realmBuilderBase().setUsePreemptiveAuth(true), 3);
    }

    @Test
    public void lazyNTLMAuthGetTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthWithGetTest(this.realmBuilderBase(), 1);
    }

    @Test
    public void preemptiveNTLMAuthGetTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthWithGetTest(this.realmBuilderBase().setUsePreemptiveAuth(true), 1);
    }

    @Test
    public void lazyNTLMAuthMultipleGetTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthWithGetTest(this.realmBuilderBase(), 3);
    }

    @Test
    public void preemptiveNTLMAuthMultipleGetTest() throws IOException, InterruptedException, ExecutionException {
        this.ntlmAuthWithGetTest(this.realmBuilderBase().setUsePreemptiveAuth(true), 3);
    }

    @Test
    public void ntlmCustomConnectionManagementOnEachCredentialsSet() throws Exception {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().build();
        this.client = this.getAsyncHttpClient(config);
        Future<Response> responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase());
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)200);
        responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase().setPassword("goat"));
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)401);
        this.client.close();
        Assert.assertEquals((int)seenClients.size(), (int)2);
    }

    @Test
    public void renegotiateNTLMCredentials() throws Exception {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().build();
        this.client = this.getAsyncHttpClient(config);
        Future<Response> responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase());
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)200);
        responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase());
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)200);
        responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase().setPassword("goat"));
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)401);
        responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase().setPassword("goat"));
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)401);
        responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase());
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)200);
        authenticatedClients.clear();
        responseFuture = this.makeNtlmAuthenticatedRequestWithCredentials(this.realmBuilderBase());
        Assert.assertEquals((int)responseFuture.get().getStatusCode(), (int)200);
        this.client.close();
        Assert.assertEquals((int)seenClients.size(), (int)2);
        Assert.assertEquals((int)authenticatedClients.size(), (int)1);
    }

    public static class NTLMHandler
    extends HandlerWrapper {
        private final boolean ntlmForceSendPayloadOnType1;

        public NTLMHandler(boolean ntlmForceSendPayloadOnType1) {
            this.ntlmForceSendPayloadOnType1 = ntlmForceSendPayloadOnType1;
        }

        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            seenClients.add(request.getRemoteInetSocketAddress().toString());
            LOGGER.error("Seen socket address = {}", (Object)request.getRemoteInetSocketAddress());
            String authorization = httpRequest.getHeader("Authorization");
            if (authenticatedClients.contains(request.getRemoteInetSocketAddress().toString())) {
                if (request.getMethod().equals(HttpMethod.POST.asString())) {
                    Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)httpRequest.getInputStream())), (String)NTLMTest.PAYLOAD);
                }
                httpResponse.setStatus(200);
            } else if (authorization == null) {
                httpResponse.setStatus(401);
                httpResponse.setHeader("WWW-Authenticate", "NTLM");
                if (request.getMethod().equals(HttpMethod.POST.asString())) {
                    Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)httpRequest.getInputStream())), (String)NTLMTest.PAYLOAD);
                }
            } else if (authorization.equals("NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==")) {
                httpResponse.setStatus(401);
                httpResponse.setHeader("WWW-Authenticate", "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
                if (request.getMethod().equals(HttpMethod.POST.asString())) {
                    if (this.ntlmForceSendPayloadOnType1) {
                        Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)httpRequest.getInputStream())), (String)NTLMTest.PAYLOAD);
                    } else {
                        Assert.assertEquals((int)httpRequest.getContentLength(), (int)0, (String)"Type 1 message should not contain body");
                    }
                }
            } else if (authorization.equals("NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAASABIAmAAAAAAAAACqAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABMAGkAZwBoAHQAQwBpAHQAeQA=")) {
                authenticatedClients.add(request.getRemoteInetSocketAddress().toString());
                if (request.getMethod().equals(HttpMethod.POST.asString())) {
                    Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)httpRequest.getInputStream())), (String)NTLMTest.PAYLOAD);
                }
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(401);
            }
            httpResponse.setContentLength(0);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

