/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async.grizzly;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.async.NTLMTest;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class GrizzlyNTLMTestWithForcePayloadOnType1Test
extends NTLMTest {
    private static final String NTLM_FORCE_SEND_PAYLOAD_ON_TYPE1_SYS_PROP_NAME = "mule.ntlm.force.send.payload.on.type1";
    private static TestClassLoader testClassLoader;
    private static Constructor<?> asyncProviderImplCtor;

    @BeforeClass
    public static void createTestClassLoader() {
        URL[] urls = new URL[]{GrizzlyAsyncHttpProvider.class.getProtectionDomain().getCodeSource().getLocation()};
        testClassLoader = new TestClassLoader(urls, NTLMTest.class.getClassLoader());
    }

    @BeforeClass
    public static void getProviderImplConstructor() throws ReflectiveOperationException {
        Class<?> asyncProviderImplClass = Class.forName(GrizzlyAsyncHttpProvider.class.getName(), true, testClassLoader);
        asyncProviderImplCtor = asyncProviderImplClass.getConstructor(AsyncHttpClientConfig.class);
    }

    @AfterClass
    public static void closeTestClassLoader() throws IOException {
        testClassLoader.close();
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new NTLMTest.NTLMHandler(true);
    }

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        try {
            System.setProperty(NTLM_FORCE_SEND_PAYLOAD_ON_TYPE1_SYS_PROP_NAME, "true");
            AsyncHttpClient asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)asyncProviderImplCtor.newInstance(config), config);
            return asyncHttpClient;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        finally {
            System.setProperty(NTLM_FORCE_SEND_PAYLOAD_ON_TYPE1_SYS_PROP_NAME, "false");
        }
    }

    private static class TestClassLoader
    extends URLClassLoader {
        private static final String GRIZZLY_PROVIDERS_PACKAGE_NAME = "com.ning.http.client.providers.grizzly.";

        public TestClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.mustReload(name)) {
                return super.findClass(name);
            }
            return super.loadClass(name);
        }

        private boolean mustReload(String name) {
            return name.startsWith(GRIZZLY_PROVIDERS_PACKAGE_NAME);
        }
    }
}

