/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractBasicTest {
    public static final String TEXT_HTML_CONTENT_TYPE_WITH_UTF_8_CHARSET = "text/html; charset=utf-8";
    protected final Logger log = LoggerFactory.getLogger(AbstractBasicTest.class);
    protected Server server;
    protected int port1;
    protected int port2;
    public static final int TIMEOUT = 30;

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.server.stop();
    }

    protected int findFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    protected String getTargetUrl() {
        return String.format("http://127.0.0.1:%d/foo/test", this.port1);
    }

    protected String getTargetUrlWithUpperCaseSchema() {
        return String.format("HTTP://127.0.0.1:%d/foo/test", this.port1);
    }

    protected String getTargetUrl2() {
        return String.format("https://127.0.0.1:%d/foo/test", this.port2);
    }

    public AbstractHandler configureHandler() throws Exception {
        return new EchoHandler();
    }

    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port2);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    public abstract AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig var1);

    public static class EchoHandler
    extends HandlerWrapper {
        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            String queryString;
            String param;
            if (httpRequest.getHeader("X-HEAD") != null) {
                httpResponse.setContentLength(1);
            }
            if (httpRequest.getHeader("X-ISO") != null) {
                httpResponse.setContentType("text/html; charset=ISO-8859-1");
            } else {
                httpResponse.setContentType(AbstractBasicTest.TEXT_HTML_CONTENT_TYPE_WITH_UTF_8_CHARSET);
            }
            if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
                httpResponse.addHeader("Allow", "GET,HEAD,POST,OPTIONS,TRACE");
            }
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                param = e.nextElement().toString();
                if (param.startsWith("LockThread")) {
                    try {
                        Thread.sleep(40000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (param.startsWith("X-redirect")) {
                    httpResponse.sendRedirect(httpRequest.getHeader("X-redirect"));
                    return;
                }
                if (param.startsWith("Y-")) {
                    httpResponse.addHeader(param.substring(2), httpRequest.getHeader(param));
                    continue;
                }
                httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
            }
            Enumeration i = httpRequest.getParameterNames();
            StringBuilder requestBody = new StringBuilder();
            while (i.hasMoreElements()) {
                param = i.nextElement().toString();
                httpResponse.addHeader("X-" + param, httpRequest.getParameter(param));
                requestBody.append(param);
                requestBody.append("_");
            }
            String pathInfo = httpRequest.getPathInfo();
            if (pathInfo != null) {
                httpResponse.addHeader("X-pathInfo", pathInfo);
            }
            if ((queryString = httpRequest.getQueryString()) != null) {
                httpResponse.addHeader("X-queryString", queryString);
            }
            httpResponse.addHeader("X-KEEP-ALIVE", httpRequest.getRemoteAddr() + ":" + httpRequest.getRemotePort());
            Cookie[] cs = httpRequest.getCookies();
            if (cs != null) {
                for (Cookie c : cs) {
                    httpResponse.addCookie(c);
                }
            }
            if (requestBody.length() > 0) {
                httpResponse.getOutputStream().write(requestBody.toString().getBytes());
            }
            int size = 16384;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                int read = 0;
                while (read > -1) {
                    read = httpRequest.getInputStream().read(bytes);
                    if (read <= 0) continue;
                    httpResponse.getOutputStream().write(bytes, 0, read);
                }
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }

    public static class AsyncHandlerAdapter
    implements AsyncHandler<String> {
        public void onThrowable(Throwable t) {
            t.printStackTrace();
            Assert.fail((String)"Unexpected exception", (Throwable)t);
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return AsyncHandler.STATE.CONTINUE;
        }

        public String onCompleted() throws Exception {
            return "";
        }
    }

    public static class AsyncCompletionHandlerAdapter
    extends AsyncCompletionHandler<Response> {
        public Response onCompleted(Response response) throws Exception {
            return response;
        }

        public void onThrowable(Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
        }
    }
}

