/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.ResponseFilter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class PostRedirectGetTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new PostRedirectGetHandler();
    }

    @Test(groups={"standalone", "post_redirect_get"}, enabled=false)
    public void postRedirectGet302Test() throws Exception {
        this.doTestPositive(302);
    }

    @Test(groups={"standalone", "post_redirect_get"}, enabled=false)
    public void postRedirectGet302StrictTest() throws Exception {
        this.doTestNegative(302, true);
    }

    @Test(groups={"standalone", "post_redirect_get"}, enabled=false)
    public void postRedirectGet303Test() throws Exception {
        this.doTestPositive(303);
    }

    @Test(groups={"standalone", "post_redirect_get"}, enabled=false)
    public void postRedirectGet301Test() throws Exception {
        this.doTestNegative(301, false);
    }

    @Test(groups={"standalone", "post_redirect_get"}, enabled=false)
    public void postRedirectGet307Test() throws Exception {
        this.doTestNegative(307, false);
    }

    private void doTestNegative(int status, boolean strict) throws Exception {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).setStrict302Handling(strict).addResponseFilter(new ResponseFilter(){

            public FilterContext filter(FilterContext ctx) throws FilterException {
                ctx.getResponseHeaders().getHeaders().get((Object)"x-expect-post");
                ctx.getRequest().getHeaders().add("x-expect-post", "true");
                ctx.getRequest().getHeaders().remove((Object)"x-redirect");
                return ctx;
            }
        }).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Request request = new RequestBuilder("POST").setUrl(this.getTargetUrl()).addFormParam("q", "a b").addHeader("x-redirect", status + "@http://localhost:" + this.port1 + "/foo/bar/baz").addHeader("x-negative", "true").build();
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Integer>(){

                public Integer onCompleted(Response response) throws Exception {
                    return response.getStatusCode();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            int statusCode = (Integer)responseFuture.get();
            Assert.assertEquals((int)statusCode, (int)200);
        }
    }

    private void doTestPositive(int status) throws Exception {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).addResponseFilter(new ResponseFilter(){

            public FilterContext filter(FilterContext ctx) throws FilterException {
                ctx.getResponseHeaders().getHeaders().get((Object)"x-expect-get");
                ctx.getRequest().getHeaders().add("x-expect-get", "true");
                ctx.getRequest().getHeaders().remove((Object)"x-redirect");
                return ctx;
            }
        }).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Request request = new RequestBuilder("POST").setUrl(this.getTargetUrl()).addFormParam("q", "a b").addHeader("x-redirect", status + "@http://localhost:" + this.port1 + "/foo/bar/baz").build();
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Integer>(){

                public Integer onCompleted(Response response) throws Exception {
                    return response.getStatusCode();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            int statusCode = (Integer)responseFuture.get();
            Assert.assertEquals((int)statusCode, (int)200);
        }
    }

    public static class PostRedirectGetHandler
    extends AbstractHandler {
        final AtomicInteger counter = new AtomicInteger();

        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            boolean expectPost;
            boolean expectGet = httpRequest.getHeader("x-expect-get") != null;
            boolean bl = expectPost = httpRequest.getHeader("x-expect-post") != null;
            if (expectGet) {
                String method = request.getMethod();
                if (!"GET".equals(method)) {
                    httpResponse.sendError(500, "Incorrect method.  Expected GET, received " + method);
                    return;
                }
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write("OK".getBytes());
                httpResponse.getOutputStream().flush();
                return;
            }
            if (expectPost) {
                String method = request.getMethod();
                if (!"POST".equals(method)) {
                    httpResponse.sendError(500, "Incorrect method.  Expected POST, received " + method);
                    return;
                }
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write("OK".getBytes());
                httpResponse.getOutputStream().flush();
                return;
            }
            String header = httpRequest.getHeader("x-redirect");
            if (header != null) {
                int redirectCode;
                String[] parts = header.split("@");
                try {
                    redirectCode = Integer.parseInt(parts[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    httpResponse.sendError(500, "Unable to parse redirect code");
                    return;
                }
                httpResponse.setStatus(redirectCode);
                if (httpRequest.getHeader("x-negative") == null) {
                    httpResponse.addHeader("x-expect-get", "true");
                } else {
                    httpResponse.addHeader("x-expect-post", "true");
                }
                httpResponse.setContentLength(0);
                httpResponse.addHeader("Location", parts[1] + this.counter.getAndIncrement());
                httpResponse.getOutputStream().flush();
                return;
            }
            httpResponse.sendError(500);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

