/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async.grizzly;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GrizzlyNoTransferEncodingTest {
    private static final String TEST_MESSAGE = "Hello World!";
    private HttpServer server;
    private int port;

    @BeforeMethod
    public void setup() throws Exception {
        this.server = new HttpServer();
        NetworkListener listener = new NetworkListener("server", "0.0.0.0", 0);
        listener.setChunkingEnabled(false);
        this.server.addListener(listener);
        this.server.getServerConfiguration().addHttpHandler(new HttpHandler(){

            public void service(Request request, org.glassfish.grizzly.http.server.Response response) throws Exception {
                response.setContentType("plain/text;charset=\"utf-8\"");
                response.flush();
                response.getWriter().write(GrizzlyNoTransferEncodingTest.TEST_MESSAGE);
            }
        }, new String[]{"/test"});
        this.server.start();
        this.port = listener.getPort();
    }

    @AfterMethod
    public void tearDown() {
        this.server.shutdownNow();
        this.server = null;
    }

    @Test
    public void testNoTransferEncoding() throws Exception {
        String url = "http://localhost:" + this.port + "/test";
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setFollowRedirect(false).setConnectTimeout(15000).setRequestTimeout(15000).setAllowPoolingConnections(false).setDisableUrlEncodingForBoundedRequests(true).setIOThreadMultiplier(2).build();
        try (AsyncHttpClient client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);){
            ListenableFuture f = client.prepareGet(url).execute();
            Response r = (Response)f.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((String)TEST_MESSAGE, (String)r.getResponseBody());
        }
    }
}

