/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.security.Constraint;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class DigestAuthTest
extends AbstractBasicTest {
    private static final String user = "user";
    private static final String admin = "admin";

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.DEBUG);
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HashLoginService loginService = new HashLoginService("MyRealm", "src/test/resources/realm.properties");
        this.server.addBean((Object)loginService);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{user, admin});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        ArrayList<ConstraintMapping> cm = new ArrayList<ConstraintMapping>();
        cm.add(mapping);
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add(user);
        knownRoles.add(admin);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setConstraintMappings(cm, knownRoles);
        security.setAuthenticator((Authenticator)new DigestAuthenticator());
        security.setLoginService((LoginService)loginService);
        security.setHandler((Handler)this.configureHandler());
        this.server.setHandler((Handler)security);
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"standalone", "default_provider"})
    public void digestAuthTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet("http://127.0.0.1:" + this.port1 + "/").setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).setRealmName("MyRealm").setScheme(Realm.AuthScheme.DIGEST).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(60L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void digestAuthTestWithoutScheme() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet("http://127.0.0.1:" + this.port1 + "/").setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).setRealmName("MyRealm").build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(60L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void digestAuthNegativeTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet("http://127.0.0.1:" + this.port1 + "/").setRealm(new Realm.RealmBuilder().setPrincipal("fake").setPassword(admin).setScheme(Realm.AuthScheme.DIGEST).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(20L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)401);
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SimpleHandler();
    }

    private class SimpleHandler
    extends HandlerWrapper {
        private SimpleHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.addHeader("X-Auth", request.getHeader("Authorization"));
            response.setStatus(200);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

