/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ListenableFutureTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void testListenableFuture() throws Throwable {
        final AtomicInteger statusCode = new AtomicInteger(500);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final ListenableFuture future = client.prepareGet(this.getTargetUrl()).execute();
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        statusCode.set(((Response)future.get()).getStatusCode());
                        latch.countDown();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }, (Executor)Executors.newFixedThreadPool(1));
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((int)statusCode.get(), (int)200);
        }
    }
}

