/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.ProviderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.security.Constraint;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MultipleAuthenticationMethodsSupportedTest
extends AbstractBasicTest {
    private static final String user = "user";
    private static final String admin = "admin";
    private static final String TEST_REALM = "MyRealm";
    private static final String AUTH_HEADER_NAME = "X-Auth";

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return ProviderUtil.grizzlyProvider(config);
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SimpleHandler();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HashLoginService loginService = new HashLoginService(TEST_REALM, "src/test/resources/realm.properties");
        this.server.addBean((Object)loginService);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{user, admin});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        ArrayList<ConstraintMapping> cm = new ArrayList<ConstraintMapping>();
        cm.add(mapping);
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add(user);
        knownRoles.add(admin);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setConstraintMappings(cm, knownRoles);
        security.setAuthenticator((Authenticator)new MyDigestAuthenticator());
        security.setLoginService((LoginService)loginService);
        security.setHandler((Handler)this.configureHandler());
        this.server.setHandler((Handler)security);
        this.server.start();
    }

    @Test(groups={"standalone", "default_provider"})
    public void EventFilterMatchesHttpHeaderWithSetSchemeForAuthorization() throws ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet("http://127.0.0.1:" + this.port1 + "/").setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).setRealmName(TEST_REALM).setScheme(Realm.AuthScheme.DIGEST).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(60L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertNotNull((Object)resp.getHeader(AUTH_HEADER_NAME));
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void EventFilterGetsFirstHttpAuthHeaderWithoutSetSchemeForAuthorization() throws ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet("http://127.0.0.1:" + this.port1 + "/").setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).setRealmName(TEST_REALM).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(60L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)401);
            Assert.assertNotNull((Object)resp.getHeader(HttpHeader.WWW_AUTHENTICATE.toString()));
        }
    }

    private class SimpleHandler
    extends HandlerWrapper {
        private SimpleHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.addHeader(MultipleAuthenticationMethodsSupportedTest.AUTH_HEADER_NAME, request.getHeader("Authorization"));
            response.setStatus(200);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }

    private class MyDigestAuthenticator
    extends DigestAuthenticator {
        private MyDigestAuthenticator() {
        }

        public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
            HttpServletRequest request = (HttpServletRequest)req;
            String wwwAuthHeader = ((HttpServletRequest)req).getHeader(HttpHeader.WWW_AUTHENTICATE.name());
            String authHeader = ((HttpServletRequest)req).getHeader(HttpHeader.AUTHORIZATION.name());
            if (wwwAuthHeader == null && authHeader == null) {
                try {
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.setHeader(HttpHeader.WWW_AUTHENTICATE.toString(), "Basic realm=\"MyRealm\"");
                    response.addHeader(HttpHeader.WWW_AUTHENTICATE.toString(), "Digest realm=\"MyRealm\", domain=\"/\", nonce=\"" + this.newNonce((Request)request) + "\", algorithm=MD5, qop=\"auth\", stale=false");
                    response.addHeader(HttpHeader.WWW_AUTHENTICATE.toString(), Realm.AuthScheme.NTLM.name());
                    response.sendError(401);
                    return Authentication.SEND_CONTINUE;
                }
                catch (IOException var14) {
                    throw new ServerAuthException((Throwable)var14);
                }
            }
            return super.validateRequest(req, res, mandatory);
        }
    }
}

