/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ws.AbstractBasicTest;
import com.ning.http.client.ws.EchoTextWebSocketServlet;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketTextListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.io.File;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public abstract class ProxyTunnellingTest
extends AbstractBasicTest {
    int port2;
    private Server server2;

    @Override
    public void setUpGlobal() {
    }

    private void setUpServers(ServerConnector server2Connector) throws Exception {
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.getServer());
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.addConnector((Connector)listener);
        this.setHandler((Handler)new ConnectHandler());
        this.start();
        server2Connector.setHost("127.0.0.1");
        server2Connector.setPort(this.port2);
        this.server2.addConnector((Connector)server2Connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server2.setHandler((Handler)context);
        ServletHolder echo = new ServletHolder((Servlet)this.getWebSocketHandler());
        context.addServlet(echo, "/*");
        this.server2.start();
        this.log.info("Local HTTP server started successfully");
    }

    private void setUpServer() throws Exception {
        this.server2 = new Server();
        this.setUpServers(new ServerConnector(this.server2));
    }

    private void setUpSSlServer2() throws Exception {
        this.server2 = new Server();
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port2);
        https_config.setOutputBufferSize(32768);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        SslContextFactory sslContextFactory = new SslContextFactory();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        this.log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keyStoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keyStoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        this.log.info("SSL keystore path: {}", (Object)trustStoreFile);
        ServerConnector https_connector = new ServerConnector(this.server2, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        https_connector.setPort(this.port2);
        https_connector.setIdleTimeout(500000L);
        this.setUpServers(https_connector);
    }

    @Override
    public WebSocketServlet getWebSocketHandler() {
        return new EchoTextWebSocketServlet();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.stop();
        if (this.server2 != null) {
            this.server2.stop();
        }
        this.server2 = null;
    }

    @Test(timeOut=60000L)
    public void echoWSText() throws Exception {
        this.setUpServer();
        this.runTest("ws");
    }

    @Test(timeOut=60000L)
    public void echoWSSText() throws Exception {
        this.setUpSSlServer2();
        this.runTest("wss");
    }

    private void runTest(String protocol) throws Exception {
        String targetUrl = String.format("%s://127.0.0.1:%d/", protocol, this.port2);
        ProxyServer ps = new ProxyServer(ProxyServer.Protocol.HTTP, "127.0.0.1", this.port1);
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setProxyServer(ps).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient asyncHttpClient = this.getAsyncHttpClient(config);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)asyncHttpClient.prepareGet(targetUrl).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }
}

