/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.security.Constraint;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class BasicAuthTest
extends AbstractBasicTest {
    protected static final String MY_MESSAGE = "my message";
    protected static final String user = "user";
    protected static final String admin = "admin";
    private Server server2;
    private Server serverNoAuth;
    private int portNoAuth;

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.DEBUG);
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HashLoginService loginService = new HashLoginService("MyRealm", "src/test/resources/realm.properties");
        this.server.addBean((Object)loginService);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{user, admin});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        ArrayList<ConstraintMapping> cm = new ArrayList<ConstraintMapping>();
        cm.add(mapping);
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add(user);
        knownRoles.add(admin);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setConstraintMappings(cm, knownRoles);
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)loginService);
        security.setHandler((Handler)this.configureHandler());
        this.server.setHandler((Handler)security);
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    private String getFileContent(File file) {
        FileInputStream in = null;
        try {
            if (file.exists() && file.canRead()) {
                int read;
                StringBuilder sb = new StringBuilder(128);
                byte[] b = new byte[512];
                in = new FileInputStream(file);
                while ((read = in.read(b)) != -1) {
                    sb.append(new String(b, 0, read, "UTF-8"));
                }
                String string = sb.toString();
                return string;
            }
            try {
                throw new IllegalArgumentException("File does not exist or cannot be read: " + file.getCanonicalPath());
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setUpSecondServer() throws Exception {
        this.server2 = new Server();
        this.port2 = this.findFreePort();
        ServerConnector connector = new ServerConnector(this.server2);
        connector.setHost("127.0.0.1");
        connector.setPort(this.port2);
        this.server2.addConnector((Connector)connector);
        HashLoginService loginService = new HashLoginService("MyRealm", "src/test/resources/realm.properties");
        this.server2.addBean((Object)loginService);
        Constraint constraint = new Constraint();
        constraint.setName("DIGEST");
        constraint.setRoles(new String[]{user, admin});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add(user);
        knownRoles.add(admin);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler(){

            public void handle(String arg0, Request arg1, HttpServletRequest arg2, HttpServletResponse arg3) throws IOException, ServletException {
                System.err.println("request in security handler");
                System.err.println("Authorization: " + arg2.getHeader("Authorization"));
                System.err.println("RequestUri: " + arg2.getRequestURI());
                super.handle(arg0, arg1, arg2, arg3);
            }
        };
        ArrayList<ConstraintMapping> cm = new ArrayList<ConstraintMapping>();
        cm.add(mapping);
        security.setConstraintMappings(cm, knownRoles);
        security.setAuthenticator((Authenticator)new DigestAuthenticator());
        security.setLoginService((LoginService)loginService);
        security.setHandler((Handler)new RedirectHandler());
        this.server2.setHandler((Handler)security);
        this.server2.start();
    }

    private void stopSecondServer() throws Exception {
        this.server2.stop();
    }

    private void setUpServerNoAuth() throws Exception {
        this.serverNoAuth = new Server();
        this.portNoAuth = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.serverNoAuth);
        listener.setHost("127.0.0.1");
        listener.setPort(this.portNoAuth);
        this.serverNoAuth.addConnector((Connector)listener);
        this.serverNoAuth.setHandler((Handler)new SimpleHandler());
        this.serverNoAuth.start();
    }

    private void stopServerNoAuth() throws Exception {
        this.serverNoAuth.stop();
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthTestWithUpperCaseSchema() throws ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrlWithUpperCaseSchema()).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void redirectAndBasicAuthTest() throws Exception, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setFollowRedirect(true).setMaxRedirects(10).build());){
            this.setUpSecondServer();
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl2()).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp, (String)"Response shouldn't be null");
            Assert.assertEquals((int)resp.getStatusCode(), (int)200, (String)"Status code should be 200-OK");
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"), (String)"X-Auth shouldn't be null");
        }
        finally {
            this.stopSecondServer();
        }
    }

    @Override
    protected String getTargetUrl() {
        return "http://127.0.0.1:" + this.port1 + "/";
    }

    @Override
    protected String getTargetUrl2() {
        return "http://127.0.0.1:" + this.port2 + "/uff";
    }

    protected String getTargetUrlNoAuth() {
        return "http://127.0.0.1:" + this.portNoAuth + "/";
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SimpleHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void basic401Test() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setHeader("X-401", "401").setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute((AsyncHandler)new AsyncHandler<Integer>(){
                private HttpResponseStatus status;

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    if (this.status.getStatusCode() != 200) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Integer onCompleted() throws Exception {
                    return this.status.getStatusCode();
                }
            });
            Integer statusCode = (Integer)f.get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)statusCode);
            Assert.assertEquals((int)statusCode, (int)401);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void basicAuthTestPreemtiveTest() throws Exception, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            this.setUpServerNoAuth();
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrlNoAuth()).setRealm(new Realm.RealmBuilder().setScheme(Realm.AuthScheme.BASIC).setPrincipal(user).setPassword(admin).setUsePreemptiveAuth(true).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
        finally {
            this.stopServerNoAuth();
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthNegativeTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(new Realm.RealmBuilder().setPrincipal("fake").setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)401);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthInputStreamTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ByteArrayInputStream is = new ByteArrayInputStream("test".getBytes());
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody((InputStream)is).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(30L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)"test");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthFileTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            String fileContent = this.getFileContent(file);
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file)).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)fileContent);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthAsyncConfigTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build()).build());){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            String fileContent = this.getFileContent(file);
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file);
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)fileContent);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicAuthFileNoKeepAliveTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(false).build());){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            String fileContent = this.getFileContent(file);
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file)).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)fileContent);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void noneAuthTest() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).build());
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertNotNull((Object)resp.getHeader("X-Auth"));
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    private class RedirectHandler
    extends HandlerWrapper {
        private RedirectHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            System.err.println("redirecthandler");
            System.err.println("request: " + request.getRequestURI());
            if ("/uff".equals(request.getRequestURI())) {
                System.err.println("redirect to /bla");
                response.setStatus(302);
                response.setHeader("Location", "/bla");
                response.getOutputStream().flush();
                response.getOutputStream().close();
            } else {
                System.err.println("got redirected" + request.getRequestURI());
                response.setStatus(200);
                response.addHeader("X-Auth", request.getHeader("Authorization"));
                response.addHeader("X-Content-Length", String.valueOf(request.getContentLength()));
                byte[] b = "content".getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
    }

    private class SimpleHandler
    extends HandlerWrapper {
        private SimpleHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getHeader("X-401") != null) {
                response.setStatus(401);
                response.setContentLength(0);
            } else {
                int read;
                response.addHeader("X-Auth", request.getHeader("Authorization"));
                response.addHeader("X-Content-Length", String.valueOf(request.getContentLength()));
                response.setStatus(200);
                int size = 10240;
                if (request.getContentLength() > 0) {
                    size = request.getContentLength();
                }
                byte[] bytes = new byte[size];
                int contentLength = 0;
                if (bytes.length > 0 && (read = request.getInputStream().read(bytes)) > 0) {
                    contentLength = read;
                    response.getOutputStream().write(bytes, 0, read);
                }
                response.setContentLength(contentLength);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

