/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.Param;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class RequestBuilderTest {
    private static final String SAFE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890-_~.";
    private static final String HEX_CHARS = "0123456789ABCDEF";

    @Test(groups={"standalone", "default_provider"})
    public void testEncodesQueryParameters() throws UnsupportedEncodingException {
        String[] values;
        for (String value : values = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKQLMNOPQRSTUVWXYZ", "1234567890", "1234567890", "`~!@#$%^&*()", "`~!@#$%^&*()", "_+-=,.<>/?", "_+-=,.<>/?", ";:'\"[]{}\\| ", ";:'\"[]{}\\| "}) {
            RequestBuilder builder = new RequestBuilder("GET").setUrl("http://example.com/").addQueryParam("name", value);
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (SAFE_CHARS.indexOf(c) >= 0) {
                    sb.append(c);
                    continue;
                }
                int hi = c >> 4;
                int lo = c & 0xF;
                sb.append('%').append(HEX_CHARS.charAt(hi)).append(HEX_CHARS.charAt(lo));
            }
            String expValue = sb.toString();
            Request request = builder.build();
            Assert.assertEquals((String)request.getUrl(), (String)("http://example.com/?name=" + expValue));
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testChaining() throws IOException, ExecutionException, InterruptedException {
        Request request = new RequestBuilder("GET").setUrl("http://foo.com").addQueryParam("x", "value").build();
        Request request2 = new RequestBuilder(request).build();
        Assert.assertEquals((Object)request2.getUri(), (Object)request.getUri());
    }

    @Test(groups={"standalone", "default_provider"})
    public void testParsesQueryParams() throws IOException, ExecutionException, InterruptedException {
        Request request = new RequestBuilder("GET").setUrl("http://foo.com/?param1=value1").addQueryParam("param2", "value2").build();
        Assert.assertEquals((String)request.getUrl(), (String)"http://foo.com/?param1=value1&param2=value2");
        List params = request.getQueryParams();
        Assert.assertEquals((int)params.size(), (int)2);
        Assert.assertEquals(params.get(0), (Object)new Param("param1", "value1"));
        Assert.assertEquals(params.get(1), (Object)new Param("param2", "value2"));
    }

    @Test(groups={"standalone", "default_provider"})
    public void testUserProvidedRequestMethod() {
        Request req = new RequestBuilder("ABC").setUrl("http://foo.com").build();
        Assert.assertEquals((String)req.getMethod(), (String)"ABC");
        Assert.assertEquals((String)req.getUrl(), (String)"http://foo.com");
    }

    @Test(groups={"standalone", "default_provider"})
    public void testPercentageEncodedUserInfo() {
        Request req = new RequestBuilder("GET").setUrl("http://hello:wor%20ld@foo.com").build();
        Assert.assertEquals((String)req.getMethod(), (String)"GET");
        Assert.assertEquals((String)req.getUrl(), (String)"http://hello:wor%20ld@foo.com");
    }

    @Test(groups={"standalone", "default_provider"})
    public void testContentTypeCharsetToBodyEncoding() {
        Request req = new RequestBuilder("GET").setHeader("Content-Type", "application/json; charset=XXXX").build();
        Assert.assertEquals((String)req.getBodyEncoding(), (String)"XXXX");
        Request req2 = new RequestBuilder("GET").setHeader("Content-Type", "application/json; charset=\"XXXX\"").build();
        Assert.assertEquals((String)req2.getBodyEncoding(), (String)"XXXX");
    }

    @Test(groups={"standalone", "default_provider"})
    public void testAddQueryParameter() throws UnsupportedEncodingException {
        RequestBuilder rb = new RequestBuilder("GET", false).setUrl("http://example.com/path").addQueryParam("a", "1?&").addQueryParam("b", "+ =");
        Request request = rb.build();
        Assert.assertEquals((String)request.getUrl(), (String)"http://example.com/path?a=1%3F%26&b=%2B%20%3D");
    }

    @Test(groups={"standalone", "default_provider"})
    public void testRawUrlQuery() throws UnsupportedEncodingException, URISyntaxException {
        String preEncodedUrl = "http://example.com/space%20mirror.php?%3Bteile";
        RequestBuilder rb = new RequestBuilder("GET", true).setUrl(preEncodedUrl);
        Request request = rb.build();
        Assert.assertEquals((String)request.getUrl(), (String)preEncodedUrl);
        Assert.assertEquals((String)request.getUri().toJavaNetURI().toString(), (String)preEncodedUrl);
    }

    @Test(groups={"standalone", "default_provider"})
    public void testCookieReplace() {
        RequestBuilder rb = new RequestBuilder();
        rb.addOrReplaceCookie(CookieDecoder.decode((String)"TheCookieName=OldCookieValue"));
        rb.addOrReplaceCookie(CookieDecoder.decode((String)"TheCookieName=NewCookieValue"));
        Request request = rb.build();
        AssertJUnit.assertFalse((boolean)this.containsCookie(request, "TheCookieName=OldCookieValue"));
        Assert.assertTrue((boolean)this.containsCookie(request, "TheCookieName=NewCookieValue"));
    }

    @Test(groups={"standalone", "default_provider"})
    public void testCookieRemove() {
        RequestBuilder rb = new RequestBuilder();
        rb.addOrReplaceCookie(CookieDecoder.decode((String)"TheCookieName=OldCookieValue"));
        rb.addOrReplaceCookie(CookieDecoder.decode((String)"TheCookieName=NewCookieValue; Expires=Sat, 02 Oct 1993 14:20:00 GMT"));
        Request request = rb.build();
        Assert.assertTrue((boolean)request.getCookies().isEmpty());
    }

    boolean containsCookie(Request request, String cookieAsString) {
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.toString().equals(cookieAsString)) continue;
            return true;
        }
        return false;
    }
}

