/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.BodyConsumer;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.Response;
import com.ning.http.client.SimpleAsyncHttpClient;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.consumers.AppendableBodyConsumer;
import com.ning.http.client.consumers.OutputStreamBodyConsumer;
import com.ning.http.client.generators.FileBodyGenerator;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.simple.HeaderMap;
import com.ning.http.client.simple.SimpleAHCTransferListener;
import com.ning.http.client.uri.Uri;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class SimpleAsyncHttpClientTest
extends AbstractBasicTest {
    private static final String MY_MESSAGE = "my message";

    public abstract String getProviderClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void inputStreamBodyConsumerTest() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setPooledConnectionIdleTimeout(100).setMaximumConnectionsTotal(50).setRequestTimeout(300000).setUrl(this.getTargetUrl()).setHeader("Content-Type", "text/html").build();){
            Future future = client.post((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())));
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getResponseBody(), (String)MY_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void inputStreamBodyConsumerTestWithUpperCaseSchema() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setPooledConnectionIdleTimeout(100).setMaximumConnectionsTotal(50).setRequestTimeout(300000).setUrl(this.getTargetUrlWithUpperCaseSchema()).setHeader("Content-Type", "text/html").build();){
            Future future = client.post((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())));
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getResponseBody(), (String)MY_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void stringBuilderBodyConsumerTest() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setPooledConnectionIdleTimeout(100).setMaximumConnectionsTotal(50).setRequestTimeout(300000).setUrl(this.getTargetUrl()).setHeader("Content-Type", "text/html").build();){
            StringBuilder s = new StringBuilder();
            Future future = client.post((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())), (BodyConsumer)new AppendableBodyConsumer((Appendable)s));
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)s.toString(), (String)MY_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void byteArrayOutputStreamBodyConsumerTest() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setPooledConnectionIdleTimeout(100).setMaximumConnectionsTotal(50).setRequestTimeout(300000).setUrl(this.getTargetUrl()).setHeader("Content-Type", "text/html").build();){
            ByteArrayOutputStream o = new ByteArrayOutputStream(10);
            Future future = client.post((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())), (BodyConsumer)new OutputStreamBodyConsumer((OutputStream)o));
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)o.toString(), (String)MY_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void requestByteArrayOutputStreamBodyConsumerTest() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl(this.getTargetUrl()).build();){
            ByteArrayOutputStream o = new ByteArrayOutputStream(10);
            Future future = client.post((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())), (BodyConsumer)new OutputStreamBodyConsumer((OutputStream)o));
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)o.toString(), (String)MY_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"}, enabled=true)
    public void testPutZeroBytesFileTest() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setPooledConnectionIdleTimeout(100).setMaximumConnectionsTotal(50).setRequestTimeout(5000).setUrl(this.getTargetUrl() + "/testPutZeroBytesFileTest.txt").setHeader("Content-Type", "text/plain").build();){
            File tmpfile = File.createTempFile("testPutZeroBytesFile", ".tmp");
            tmpfile.deleteOnExit();
            Future future = client.put((BodyGenerator)new FileBodyGenerator(tmpfile));
            Response response = (Response)future.get();
            tmpfile.delete();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testDerive() throws Exception {
        SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).build();
        SimpleAsyncHttpClient derived = client.derive().build();
        try {
            Assert.assertNotSame((Object)derived, (Object)client);
        }
        finally {
            client.close();
            derived.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testDeriveOverrideURL() throws Exception {
        SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl("http://invalid.url").build();
        SimpleAsyncHttpClient derived = client.derive().setUrl(this.getTargetUrl()).build();
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream(10);
            InputStreamBodyGenerator generator = new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes()));
            OutputStreamBodyConsumer consumer = new OutputStreamBodyConsumer((OutputStream)o);
            Future future = derived.post((BodyGenerator)generator, (BodyConsumer)consumer);
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)o.toString(), (String)MY_MESSAGE);
        }
        finally {
            client.close();
            derived.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testSimpleTransferListener() throws Exception {
        SimpleAHCTransferListener listener = new SimpleAHCTransferListener(){

            public void onStatus(Uri uri, int statusCode, String statusText) {
                Assert.assertEquals((int)statusCode, (int)200);
                Assert.assertEquals((String)uri.toUrl(), (String)SimpleAsyncHttpClientTest.this.getTargetUrl());
            }

            public void onHeaders(Uri uri, HeaderMap headers) {
                Assert.assertEquals((String)uri.toUrl(), (String)SimpleAsyncHttpClientTest.this.getTargetUrl());
                Assert.assertNotNull((Object)headers);
                Assert.assertTrue((!headers.isEmpty() ? 1 : 0) != 0);
                Assert.assertEquals((String)headers.getFirstValue("X-Custom"), (String)"custom");
            }

            public void onCompleted(Uri uri, int statusCode, String statusText) {
                Assert.assertEquals((int)statusCode, (int)200);
                Assert.assertEquals((String)uri.toUrl(), (String)SimpleAsyncHttpClientTest.this.getTargetUrl());
            }

            public void onBytesSent(Uri uri, long amount, long current, long total) {
                Assert.assertEquals((String)uri.toUrl(), (String)SimpleAsyncHttpClientTest.this.getTargetUrl());
                Assert.assertEquals((long)total, (long)SimpleAsyncHttpClientTest.MY_MESSAGE.getBytes().length);
            }

            public void onBytesReceived(Uri uri, long amount, long current, long total) {
                Assert.assertEquals((String)uri.toUrl(), (String)SimpleAsyncHttpClientTest.this.getTargetUrl());
                Assert.assertEquals((long)total, (long)-1L);
            }
        };
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl(this.getTargetUrl()).setHeader("Custom", "custom").setListener(listener).build();){
            ByteArrayOutputStream o = new ByteArrayOutputStream(10);
            InputStreamBodyGenerator generator = new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes()));
            OutputStreamBodyConsumer consumer = new OutputStreamBodyConsumer((OutputStream)o);
            Future future = client.post((BodyGenerator)generator, (BodyConsumer)consumer);
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)o.toString(), (String)MY_MESSAGE);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testNullUrl() throws Exception {
        try (SimpleAsyncHttpClient client = null;){
            client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).build().derive().build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testCloseDerivedValidMaster() throws Exception {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl(this.getTargetUrl()).build();){
            SimpleAsyncHttpClient derived = client.derive().build();
            derived.get().get();
            derived.close();
            Response response = (Response)client.get().get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testCloseMasterInvalidDerived() throws Exception {
        SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl(this.getTargetUrl()).build();
        SimpleAsyncHttpClient derived = client.derive().build();
        client.close();
        try {
            derived.get().get();
            Assert.fail((String)"Expected closed AHC");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        finally {
            client.close();
            derived.close();
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testMultiPartPut() throws Exception {
        this.testMultiPartPutWithCharset(this.getContentDispositionHeader(), this.getFilename());
    }

    @Test(groups={"standalone", "default_provider"})
    public void testMultiPartPost() throws Exception {
        this.testMultiPartPostCharSet(this.getContentDispositionHeader());
    }

    protected String getContentDispositionHeader() {
        return "baPart";
    }

    protected String getFilename() {
        return "fileName";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultiPartPutWithCharset(String dispositionHeaderName, String filename) throws InterruptedException, ExecutionException, IOException {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl(this.getTargetUrl() + "/multipart").build();){
            Response response = (Response)client.put(new Part[]{new ByteArrayPart(dispositionHeaderName, "testMultiPart".getBytes(StandardCharsets.UTF_8), "application/test", StandardCharsets.UTF_8, filename)}).get();
            String body = response.getResponseBody();
            String contentType = response.getHeader("X-Content-Type");
            Assert.assertTrue((boolean)contentType.contains("multipart/form-data"));
            String boundary = contentType.substring(contentType.lastIndexOf("=") + 1);
            Assert.assertTrue((boolean)body.startsWith("--" + boundary));
            Assert.assertTrue((boolean)body.trim().endsWith("--" + boundary + "--"));
            Assert.assertTrue((boolean)body.contains("Content-Disposition:"));
            Assert.assertTrue((boolean)body.contains("Content-Type: application/test"));
            Assert.assertTrue((boolean)body.contains("name=\"" + dispositionHeaderName));
            Assert.assertTrue((boolean)body.contains("filename=\"" + filename));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultiPartPostCharSet(String dispositionHeaderName) throws InterruptedException, ExecutionException, IOException {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProviderClass(this.getProviderClass()).setUrl(this.getTargetUrl() + "/multipart").build();){
            Response response = (Response)client.post(new Part[]{new ByteArrayPart(dispositionHeaderName, "testMultiPart".getBytes(StandardCharsets.UTF_8), "application/test", StandardCharsets.UTF_8, "fileName")}).get();
            String body = response.getResponseBody();
            String contentType = response.getHeader("X-Content-Type");
            Assert.assertTrue((boolean)contentType.contains("multipart/form-data"));
            String boundary = contentType.substring(contentType.lastIndexOf("=") + 1);
            Assert.assertTrue((boolean)body.startsWith("--" + boundary));
            Assert.assertTrue((boolean)body.trim().endsWith("--" + boundary + "--"));
            Assert.assertTrue((boolean)body.contains("Content-Disposition:"));
            Assert.assertTrue((boolean)body.contains("Content-Type: application/test"));
            Assert.assertTrue((boolean)body.contains("name=\"" + dispositionHeaderName));
            Assert.assertTrue((boolean)body.contains("filename=\"fileName"));
        }
    }
}

