/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async.grizzly;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.util.FreePortFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.utils.Charsets;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GrizzlyFeedableBodyGeneratorTest {
    private static final byte[] DATA = "aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ".getBytes(Charsets.ASCII_CHARSET);
    private static final int TEMP_FILE_SIZE = 0x200000;
    private static final int NON_SECURE_PORT = FreePortFinder.findFreePort();
    private static final int SECURE_PORT = FreePortFinder.findFreePort();
    private HttpServer server;
    private File tempFile;

    @BeforeMethod
    public void setup() throws Exception {
        this.generateTempFile();
        this.server = new HttpServer();
        NetworkListener nonSecure = new NetworkListener("nonsecure", "0.0.0.0", NON_SECURE_PORT);
        NetworkListener secure = new NetworkListener("secure", "0.0.0.0", SECURE_PORT);
        secure.setSecure(true);
        secure.setSSLEngineConfig(GrizzlyFeedableBodyGeneratorTest.createSSLConfig());
        this.server.addListener(nonSecure);
        this.server.addListener(secure);
        this.server.getServerConfiguration().addHttpHandler((HttpHandler)new ConsumingHandler(), new String[]{"/test"});
        this.server.start();
    }

    @AfterMethod
    public void tearDown() {
        if (!this.tempFile.delete()) {
            this.tempFile.deleteOnExit();
        }
        this.tempFile = null;
        this.server.shutdownNow();
        this.server = null;
    }

    @Test
    public void simpleFeederMultipleThreads() throws Exception {
        this.doSimpleFeeder(false);
    }

    @Test
    public void simpleFeederOverSSLMultipleThreads() throws Exception {
        this.doSimpleFeeder(true);
    }

    @Test
    public void nonBlockingFeederMultipleThreads() throws Exception {
        this.doNonBlockingFeeder(false);
    }

    @Test
    public void nonBlockingFeederOverSSLMultipleThreads() throws Exception {
        this.doNonBlockingFeeder(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSimpleFeeder(boolean secure) {
        int threadCount = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        final int port = secure ? SECURE_PORT : NON_SECURE_PORT;
        final String scheme = secure ? "https" : "http";
        ExecutorService service = Executors.newFixedThreadPool(10);
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setMaxConnectionsPerHost(60).setMaxConnections(60).setAcceptAnyCertificate(true).build();
        try (final AsyncHttpClient client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);){
            final int[] statusCodes = new int[10];
            final int[] totalsReceived = new int[10];
            final Throwable[] errors = new Throwable[10];
            int i = 0;
            while (i < 10) {
                final int idx = i++;
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        FeedableBodyGenerator generator = new FeedableBodyGenerator();
                        FeedableBodyGenerator.SimpleFeeder simpleFeeder = new FeedableBodyGenerator.SimpleFeeder(generator){

                            public void flush() throws IOException {
                                try (FileInputStream in = new FileInputStream(GrizzlyFeedableBodyGeneratorTest.this.tempFile);){
                                    int read;
                                    byte[] bytesIn = new byte[2048];
                                    while ((read = in.read(bytesIn)) != -1) {
                                        Buffer b = Buffers.wrap((MemoryManager)MemoryManager.DEFAULT_MEMORY_MANAGER, (byte[])bytesIn, (int)0, (int)read);
                                        this.feed(b, false);
                                    }
                                    this.feed(Buffers.EMPTY_BUFFER, true);
                                }
                            }
                        };
                        generator.setFeeder((FeedableBodyGenerator.Feeder)simpleFeeder);
                        generator.setMaxPendingBytes(10000);
                        RequestBuilder builder = new RequestBuilder("POST");
                        builder.setUrl(scheme + "://localhost:" + port + "/test");
                        builder.setBody((BodyGenerator)generator);
                        client.executeRequest(builder.build(), (AsyncHandler)new AsyncCompletionHandler<Response>(){

                            public Response onCompleted(Response response) throws Exception {
                                try {
                                    totalsReceived[idx] = Integer.parseInt(response.getHeader("x-total"));
                                }
                                catch (Exception e) {
                                    errors[idx] = e;
                                }
                                statusCodes[idx] = response.getStatusCode();
                                latch.countDown();
                                return response;
                            }

                            public void onThrowable(Throwable t) {
                                errors[idx] = t;
                                t.printStackTrace();
                                latch.countDown();
                            }
                        });
                    }
                });
            }
            try {
                latch.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Latch interrupted");
            }
            finally {
                service.shutdownNow();
            }
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((int)statusCodes[i], (int)200);
                Assert.assertNull((Object)errors[i]);
                Assert.assertEquals((long)totalsReceived[i], (long)this.tempFile.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNonBlockingFeeder(boolean secure) {
        int threadCount = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        final int port = secure ? SECURE_PORT : NON_SECURE_PORT;
        final String scheme = secure ? "https" : "http";
        final ExecutorService service = Executors.newCachedThreadPool();
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setMaxConnectionsPerHost(60).setMaxConnections(60).setAcceptAnyCertificate(true).build();
        try (final AsyncHttpClient client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);){
            final int[] statusCodes = new int[10];
            final int[] totalsReceived = new int[10];
            final Throwable[] errors = new Throwable[10];
            int i = 0;
            while (i < 10) {
                final int idx = i++;
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        FeedableBodyGenerator generator = new FeedableBodyGenerator();
                        FeedableBodyGenerator.NonBlockingFeeder nonBlockingFeeder = new FeedableBodyGenerator.NonBlockingFeeder(generator){
                            private final Random r;
                            private final InputStream in;
                            private final byte[] bytesIn;
                            private boolean isDone;
                            {
                                this.r = new Random();
                                this.bytesIn = new byte[2048];
                                try {
                                    this.in = new FileInputStream(GrizzlyFeedableBodyGeneratorTest.this.tempFile);
                                }
                                catch (IOException e) {
                                    throw new IllegalStateException(e);
                                }
                            }

                            public void canFeed() throws IOException {
                                int read = this.in.read(this.bytesIn);
                                if (read == -1) {
                                    this.isDone = true;
                                    this.feed(Buffers.EMPTY_BUFFER, true);
                                    return;
                                }
                                Buffer b = Buffers.wrap((MemoryManager)MemoryManager.DEFAULT_MEMORY_MANAGER, (byte[])this.bytesIn, (int)0, (int)read);
                                this.feed(b, false);
                            }

                            public boolean isDone() {
                                return this.isDone;
                            }

                            public boolean isReady() {
                                return this.r.nextInt(100) < 80;
                            }

                            public void notifyReadyToFeed(final FeedableBodyGenerator.NonBlockingFeeder.ReadyToFeedListener listener) {
                                service.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Thread.sleep(2L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        listener.ready();
                                    }
                                });
                            }
                        };
                        generator.setFeeder((FeedableBodyGenerator.Feeder)nonBlockingFeeder);
                        generator.setMaxPendingBytes(10000);
                        RequestBuilder builder = new RequestBuilder("POST");
                        builder.setUrl(scheme + "://localhost:" + port + "/test");
                        builder.setBody((BodyGenerator)generator);
                        client.executeRequest(builder.build(), (AsyncHandler)new AsyncCompletionHandler<Response>(){

                            public Response onCompleted(Response response) throws Exception {
                                try {
                                    totalsReceived[idx] = Integer.parseInt(response.getHeader("x-total"));
                                }
                                catch (Exception e) {
                                    errors[idx] = e;
                                }
                                statusCodes[idx] = response.getStatusCode();
                                latch.countDown();
                                return response;
                            }

                            public void onThrowable(Throwable t) {
                                errors[idx] = t;
                                t.printStackTrace();
                                latch.countDown();
                            }
                        });
                    }
                });
            }
            try {
                latch.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Latch interrupted");
            }
            finally {
                service.shutdownNow();
            }
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((int)statusCodes[i], (int)200);
                Assert.assertNull((Object)errors[i]);
                Assert.assertEquals((long)totalsReceived[i], (long)this.tempFile.length());
            }
        }
    }

    private static SSLEngineConfigurator createSSLConfig() throws Exception {
        URL keystoreUrl;
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        ClassLoader cl = GrizzlyFeedableBodyGeneratorTest.class.getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        if (cacertsUrl != null) {
            sslContextConfigurator.setTrustStoreFile(cacertsUrl.getFile());
            sslContextConfigurator.setTrustStorePass("changeit");
        }
        if ((keystoreUrl = cl.getResource("ssltest-keystore.jks")) != null) {
            sslContextConfigurator.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfigurator.setKeyStorePass("changeit");
        }
        return new SSLEngineConfigurator(sslContextConfigurator.createSSLContext(false), false, false, false);
    }

    private void generateTempFile() throws IOException {
        this.tempFile = File.createTempFile("feedable", null);
        byte[] chunk = new byte[1024];
        Random r = new Random(System.currentTimeMillis());
        FileOutputStream out = new FileOutputStream(this.tempFile);
        for (int total = 0; total < 0x200000; total += chunk.length) {
            for (int i = 0; i < chunk.length; ++i) {
                chunk[i] = DATA[r.nextInt(DATA.length)];
            }
            out.write(chunk);
        }
        out.flush();
        out.close();
    }

    private static final class ConsumingHandler
    extends HttpHandler {
        private ConsumingHandler() {
        }

        public void service(Request request, org.glassfish.grizzly.http.server.Response response) throws Exception {
            int read;
            int total = 0;
            byte[] bytesIn = new byte[2048];
            InputStream in = request.getInputStream();
            while ((read = in.read(bytesIn)) != -1) {
                total += read;
                Thread.sleep(5L);
            }
            response.addHeader("X-Total", Integer.toString(total));
        }
    }
}

