/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.jaxws;

import com.oracle.webservices.api.message.BasePropertySet;
import com.oracle.webservices.api.message.PropertySet;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

final class JaxwsConnection
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final Request request;
    private final Response response;
    private int status;
    private boolean outputWritten;
    private final boolean isSecure;
    private final boolean isAsync;
    final HttpAdapter httpAdapter;
    private Headers requestHeaders;
    private Headers responseHeaders;
    private static final BasePropertySet.PropertyMap model = JaxwsConnection.parse(JaxwsConnection.class);

    public JaxwsConnection(HttpAdapter httpAdapter, Request request, Response response, boolean isSecure, boolean isAsync) {
        this.httpAdapter = httpAdapter;
        this.request = request;
        this.response = response;
        this.isSecure = isSecure;
        this.isAsync = isAsync;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Headers();
            for (String headerName : this.request.getHeaderNames()) {
                ArrayList<String> headerValues = new ArrayList<String>(4);
                for (String headerValue : this.request.getHeaders(headerName)) {
                    headerValues.add(headerValue);
                }
                this.requestHeaders.put((Object)headerName, headerValues);
            }
        }
        return this.requestHeaders;
    }

    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    public Set<String> getRequestHeaderNames() {
        return this.getRequestHeaders().keySet();
    }

    public List<String> getRequestHeaderValues(@NotNull String headerName) {
        return this.getRequestHeaders().get(headerName);
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            this.responseHeaders = null;
        } else {
            if (this.responseHeaders == null) {
                this.responseHeaders = new Headers();
            } else {
                this.responseHeaders.clear();
            }
            this.responseHeaders.putAll(headers);
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeader(String key, String value) {
        this.setResponseHeader(key, Collections.singletonList(value));
    }

    public void setResponseHeader(String key, List<String> value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new Headers();
        }
        this.responseHeaders.put((Object)key, value);
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRequestScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public void setContentTypeResponseHeader(@NotNull String value) {
        this.response.setContentType(value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.status;
    }

    @NotNull
    public InputStream getInput() throws IOException {
        return this.request.getInputStream();
    }

    @NotNull
    public OutputStream getOutput() throws IOException {
        this.response.setStatus(this.status);
        if (this.responseHeaders != null) {
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                String name = (String)entry.getKey();
                if (name == null || name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Content-Length")) continue;
                for (String value : (List)entry.getValue()) {
                    this.response.addHeader(name, value);
                }
            }
        }
        return this.response.getOutputStream();
    }

    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    public Principal getUserPrincipal(Packet request) {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(Packet request, String role) {
        return false;
    }

    @NotNull
    public String getEPRAddress(Packet p, WSEndpoint endpoint) {
        PortAddressResolver resolver = this.httpAdapter.owner.createPortAddressResolver(this.getBaseAddress(), endpoint.getImplementationClass());
        String address = resolver.getAddressFor(endpoint.getServiceName(), endpoint.getPortName().getLocalPart());
        if (address == null) {
            throw new WebServiceException("WsservletMessages.SERVLET_NO_ADDRESS_AVAILABLE(" + endpoint.getPortName() + ")");
        }
        return address;
    }

    public String getWSDLAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        String eprAddress = this.getEPRAddress(request, endpoint);
        return eprAddress + "?wsdl";
    }

    @NotNull
    public String getBaseAddress() {
        return JaxwsConnection.getBaseAddress(this.request);
    }

    @NotNull
    static String getBaseAddress(Request request) {
        StringBuilder buf = new StringBuilder();
        buf.append(request.getScheme());
        buf.append("://");
        buf.append(request.getServerName());
        buf.append(':');
        buf.append(request.getServerPort());
        buf.append(request.getContextPath());
        return buf.toString();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return this.request.getMethod().getMethodString();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            if (this.isAsync) {
                this.response.resume();
            }
        }
    }

    protected BasePropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

