/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.jaxws;

import java.io.IOException;
import java.util.Random;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.jaxws.AddService;
import org.glassfish.grizzly.jaxws.JaxwsHandler;
import org.glassfish.grizzly.jaxws.addclient.AddServiceService;
import org.junit.Assert;
import org.junit.Test;

public class JaxwsTest {
    private static final int PORT = 19881;
    private HttpServer httpServer;

    @Test
    public void testSync() throws Exception {
        this.startServer((HttpHandler)new JaxwsHandler((Object)new AddService(), false));
        try {
            this.test(10);
        }
        finally {
            this.stopServer();
        }
    }

    @Test
    public void testAsync() throws Exception {
        this.startServer((HttpHandler)new JaxwsHandler((Object)new AddService(), true));
        try {
            this.test(10);
        }
        finally {
            this.stopServer();
        }
    }

    private void startServer(HttpHandler httpHandler) throws IOException {
        this.httpServer = new HttpServer();
        NetworkListener networkListener = new NetworkListener("jaxws-listener", "0.0.0.0", 19881);
        this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new StaticHttpHandler(), new String[]{"/add"});
        this.httpServer.getServerConfiguration().addHttpHandler(httpHandler, new HttpHandlerRegistration[]{HttpHandlerRegistration.bulder().contextPath("/add/a/b").urlPattern("/").build()});
        this.httpServer.addListener(networkListener);
        this.httpServer.start();
    }

    private void stopServer() {
        this.httpServer.shutdownNow();
    }

    private void test(int n) {
        Random random = new Random();
        AddServiceService service = new AddServiceService();
        org.glassfish.grizzly.jaxws.addclient.AddService port = service.getAddServicePort();
        for (int i = 0; i < n; ++i) {
            int value1 = random.nextInt(1000);
            int value2 = random.nextInt(1000);
            int result = port.add(value1, value2);
            Assert.assertEquals((long)(value1 + value2), (long)result);
        }
    }
}

