/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet.extras.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.servlet.extras.util.MultipartEntryPacket;

public class MultipartPacketBuilder {
    private static final Charset DEFAULT_HTTP_CHARSET = Constants.DEFAULT_HTTP_CHARSET;
    private static final byte[] DOUBLE_DASH = "--".getBytes(DEFAULT_HTTP_CHARSET);
    private static final byte[] CONTENT_DISPOSITION_BYTES = "Content-Disposition".getBytes(DEFAULT_HTTP_CHARSET);
    private static final byte[] CONTENT_TYPE_BYTES = "Content-Type".getBytes(DEFAULT_HTTP_CHARSET);
    private final byte[] tempEncodingBuffer = new byte[512];
    private final String boundary;
    private final List<MultipartEntryPacket> multipartEntries = new ArrayList<MultipartEntryPacket>();
    private String epilogue;
    private String preamble;

    private MultipartPacketBuilder(String boundary) {
        this.boundary = boundary;
    }

    public static MultipartPacketBuilder builder(String boundary) {
        return new MultipartPacketBuilder(boundary);
    }

    public MultipartPacketBuilder addMultipartEntry(MultipartEntryPacket multipartEntry) {
        this.multipartEntries.add(multipartEntry);
        return this;
    }

    public MultipartPacketBuilder removeMultipartEntry(MultipartEntryPacket multipartEntry) {
        this.multipartEntries.remove(multipartEntry);
        return this;
    }

    public MultipartPacketBuilder preamble(String preamble) {
        this.preamble = preamble;
        return this;
    }

    public MultipartPacketBuilder epilogue(String epilogue) {
        this.epilogue = epilogue;
        return this;
    }

    public Buffer build() {
        MemoryManager memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
        Buffer resultBuffer = null;
        boolean isFirst = true;
        for (MultipartEntryPacket entry : this.multipartEntries) {
            Buffer headerBuffer = memoryManager.allocate(2048);
            if (!isFirst) {
                headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
            } else {
                if (this.preamble != null) {
                    headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])this.tempEncodingBuffer, (String)this.preamble);
                    headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
                }
                isFirst = false;
            }
            headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])DOUBLE_DASH);
            headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])this.tempEncodingBuffer, (String)this.boundary);
            headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
            for (String headerName : entry.getHeaderNames()) {
                String headerValue = entry.getHeader(headerName);
                MultipartPacketBuilder.setHeader(memoryManager, headerBuffer, this.tempEncodingBuffer, headerName, headerValue);
            }
            if (entry.getContentDisposition() != null) {
                MultipartPacketBuilder.setHeader(memoryManager, headerBuffer, this.tempEncodingBuffer, CONTENT_DISPOSITION_BYTES, entry.getContentDisposition());
            }
            if (entry.getContentType() != null) {
                MultipartPacketBuilder.setHeader(memoryManager, headerBuffer, this.tempEncodingBuffer, CONTENT_TYPE_BYTES, entry.getContentType());
            }
            headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
            headerBuffer.trim();
            resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)resultBuffer, (Buffer)headerBuffer);
            resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)resultBuffer, (Buffer)entry.getContent());
            isFirst = false;
        }
        Buffer trailerBuffer = memoryManager.allocate(this.boundary.length() + 8);
        trailerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)trailerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
        trailerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)trailerBuffer, (byte[])DOUBLE_DASH);
        trailerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)trailerBuffer, (byte[])this.tempEncodingBuffer, (String)this.boundary);
        trailerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)trailerBuffer, (byte[])DOUBLE_DASH);
        trailerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)trailerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
        if (this.epilogue != null) {
            trailerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)trailerBuffer, (byte[])this.tempEncodingBuffer, (String)this.epilogue);
        }
        trailerBuffer.flip();
        resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, resultBuffer, (Buffer)trailerBuffer);
        return resultBuffer;
    }

    private static void setHeader(MemoryManager memoryManager, Buffer headerBuffer, byte[] tempEncodingBuffer, String headerName, String headerValue) {
        headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])tempEncodingBuffer, (String)headerName);
        headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.COLON_BYTES);
        headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, null, (String)headerValue);
        HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
    }

    private static void setHeader(MemoryManager memoryManager, Buffer headerBuffer, byte[] tempEncodingBuffer, byte[] headerName, String headerValue) {
        headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])headerName);
        headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.COLON_BYTES);
        headerBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])tempEncodingBuffer, (String)headerValue);
        HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)headerBuffer, (byte[])org.glassfish.grizzly.http.server.Constants.CRLF_BYTES);
    }
}

