/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet.extras.util;

import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.utils.Charsets;

public class MultipartEntryPacket {
    private String contentDisposition;
    private String contentType;
    protected final MimeHeaders headers = new MimeHeaders();
    private Buffer content;

    public static Builder builder() {
        return new Builder();
    }

    private MultipartEntryPacket() {
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Buffer getContent() {
        return this.content;
    }

    public Iterable<String> getHeaderNames() {
        return this.headers.names();
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public static class Builder {
        private final MultipartEntryPacket packet = new MultipartEntryPacket();

        protected Builder() {
        }

        public Builder contentDisposition(String contentDisposition) {
            this.packet.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentType(String contentType) {
            this.packet.contentType = contentType;
            return this;
        }

        public Builder header(String name, String value) {
            if ("content-disposition".equalsIgnoreCase(name)) {
                this.contentDisposition(value);
            } else if ("content-type".equalsIgnoreCase(name)) {
                this.contentType(value);
            } else {
                this.packet.headers.addValue(name).setString(value);
            }
            return this;
        }

        public Builder content(Buffer content) {
            this.packet.content = content;
            return this;
        }

        public Builder content(String content) {
            return this.content(content, this.getCharset());
        }

        public Builder content(String content, Charset charset) {
            this.packet.content = Buffers.wrap(null, (String)content, (Charset)charset);
            return this;
        }

        public final MultipartEntryPacket build() {
            return this.packet;
        }

        private Charset getCharset() {
            String charset = null;
            if (this.packet.contentType != null) {
                charset = ContentType.getCharsetFromContentType((String)this.packet.contentType);
            }
            if (charset == null) {
                return Charsets.ASCII_CHARSET;
            }
            return Charsets.lookupCharset(charset);
        }
    }
}

