/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet.extras;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.GenericCloseListener;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.servlet.extras.MultipartUploadFilter;
import org.glassfish.grizzly.servlet.extras.util.MultipartEntryPacket;
import org.glassfish.grizzly.servlet.extras.util.MultipartPacketBuilder;
import org.glassfish.grizzly.utils.ChunkingFilter;
import org.glassfish.grizzly.utils.Futures;

public class MultipartUploadFilterTest
extends TestCase {
    private static final int PORT = 9977;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicMultipartUploadFilter001() throws Exception {
        HttpServer httpServer = HttpServer.createSimpleServer((String)".", (int)9977);
        WebappContext ctx = new WebappContext("Upload Test");
        String fileContent = "One Ring to rule them all, One Ring to find them,\nOne Ring to bring them all and in the darkness bind them.";
        FilterRegistration filterRegistration = ctx.addFilter("UploadFilter", MultipartUploadFilter.class.getName());
        filterRegistration.addMappingForUrlPatterns(null, new String[]{"/upload"});
        final AtomicReference uploadedFile = new AtomicReference();
        ServletRegistration servletRegistration = ctx.addServlet("UploadValidationServlet", (Servlet)new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                Object value = req.getAttribute("org.glassfish.grizzly.multipart.UPLOADED_FILES");
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof File[]));
                File[] uploadedFiles = (File[])value;
                Assert.assertEquals((int)1, (int)uploadedFiles.length);
                File f = uploadedFiles[0];
                InputStreamReader r = new InputStreamReader(new FileInputStream(f));
                char[] buf = new char[512];
                int read = r.read(buf);
                ((Reader)r).close();
                Assert.assertEquals((String)"One Ring to rule them all, One Ring to find them,\nOne Ring to bring them all and in the darkness bind them.", (String)new String(buf, 0, read));
                Assert.assertTrue((boolean)f.exists());
                Assert.assertTrue((boolean)f.canRead());
                uploadedFile.set(f);
            }
        });
        servletRegistration.addMapping(new String[]{"/upload"});
        try {
            ctx.deploy(httpServer);
            httpServer.start();
            TCPNIOTransport clientTransport = TCPNIOTransportBuilder.newInstance().build();
            clientTransport.start();
            HttpClient client = new HttpClient(clientTransport);
            Future<Connection> conn = client.connect("localhost", 9977);
            conn.get(10L, TimeUnit.SECONDS);
            Future<HttpPacket> future = client.get(this.createMultipartPacket("One Ring to rule them all, One Ring to find them,\nOne Ring to bring them all and in the darkness bind them."));
            HttpPacket packet = future.get(10L, TimeUnit.SECONDS);
            HttpResponsePacket response = (HttpResponsePacket)packet.getHttpHeader();
            Assert.assertEquals((int)200, (int)response.getStatus());
            File f = (File)uploadedFile.get();
            Assert.assertNotNull((Object)f);
            Assert.assertFalse((boolean)f.exists());
        }
        finally {
            httpServer.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicMultipartUploadFilter002() throws Exception {
        HttpServer httpServer = HttpServer.createSimpleServer((String)".", (int)9977);
        WebappContext ctx = new WebappContext("Upload Test");
        String fileContent = "One Ring to rule them all, One Ring to find them,\nOne Ring to bring them all and in the darkness bind them.";
        FilterRegistration filterRegistration = ctx.addFilter("UploadFilter", MultipartUploadFilter.class.getName());
        filterRegistration.setInitParameter("org.glassfish.grizzly.multipart.DELETE_ON_REQUEST_END", "false");
        filterRegistration.addMappingForUrlPatterns(null, new String[]{"/upload"});
        final AtomicReference uploadedFile = new AtomicReference();
        ServletRegistration servletRegistration = ctx.addServlet("UploadValidationServlet", (Servlet)new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                Object value = req.getAttribute("org.glassfish.grizzly.multipart.UPLOADED_FILES");
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof File[]));
                File[] uploadedFiles = (File[])value;
                Assert.assertEquals((int)1, (int)uploadedFiles.length);
                File f = uploadedFiles[0];
                InputStreamReader r = new InputStreamReader(new FileInputStream(f));
                char[] buf = new char[512];
                int read = r.read(buf);
                Assert.assertEquals((String)"One Ring to rule them all, One Ring to find them,\nOne Ring to bring them all and in the darkness bind them.", (String)new String(buf, 0, read));
                Assert.assertTrue((boolean)f.exists());
                Assert.assertTrue((boolean)f.canRead());
                uploadedFile.set(f);
            }
        });
        servletRegistration.addMapping(new String[]{"/upload"});
        try {
            ctx.deploy(httpServer);
            httpServer.start();
            TCPNIOTransport clientTransport = TCPNIOTransportBuilder.newInstance().build();
            clientTransport.start();
            HttpClient client = new HttpClient(clientTransport);
            Future<Connection> conn = client.connect("localhost", 9977);
            conn.get(10L, TimeUnit.SECONDS);
            Future<HttpPacket> future = client.get(this.createMultipartPacket("One Ring to rule them all, One Ring to find them,\nOne Ring to bring them all and in the darkness bind them."));
            HttpPacket packet = future.get(10L, TimeUnit.SECONDS);
            HttpResponsePacket response = (HttpResponsePacket)packet.getHttpHeader();
            Assert.assertEquals((int)200, (int)response.getStatus());
            File f = (File)uploadedFile.get();
            Assert.assertNotNull((Object)f);
            Assert.assertTrue((boolean)f.exists());
            f.deleteOnExit();
        }
        finally {
            httpServer.shutdownNow();
        }
    }

    private HttpPacket createMultipartPacket(String content) {
        String boundary = "---------------------------103832778631715";
        MultipartPacketBuilder mpb = MultipartPacketBuilder.builder(boundary);
        mpb.preamble("preamble").epilogue("epilogue");
        mpb.addMultipartEntry(MultipartEntryPacket.builder().contentDisposition("form-data; name=\"test.txt\"; filename=\"test.txt\"").content(content).build());
        Buffer bodyBuffer = mpb.build();
        HttpRequestPacket requestHeader = ((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.POST).uri("/upload").protocol(Protocol.HTTP_1_1)).header("host", "localhost")).contentType("multipart/form-data; boundary=" + boundary)).contentLength((long)bodyBuffer.remaining())).build();
        return HttpContent.builder((HttpHeader)requestHeader).content(bodyBuffer).build();
    }

    private static class HttpClient {
        private final TCPNIOTransport transport;
        private final int chunkSize;
        private volatile Connection connection;
        private volatile FutureImpl<HttpPacket> asyncFuture;

        public HttpClient(TCPNIOTransport transport) {
            this(transport, -1);
        }

        public HttpClient(TCPNIOTransport transport, int chunkSize) {
            this.transport = transport;
            this.chunkSize = chunkSize;
        }

        public Future<Connection> connect(String host, int port) throws IOException {
            FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
            filterChainBuilder.add((Filter)new TransportFilter());
            if (this.chunkSize > 0) {
                filterChainBuilder.add((Filter)new ChunkingFilter(this.chunkSize));
            }
            filterChainBuilder.add((Filter)new HttpClientFilter());
            filterChainBuilder.add((Filter)new HttpResponseFilter());
            TCPNIOConnectorHandler connector = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)this.transport).processor((Processor)filterChainBuilder.build())).build();
            FutureImpl future = Futures.createSafeFuture();
            connector.connect((Object)new InetSocketAddress(host, port), Futures.toCompletionHandler((FutureImpl)future, (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection result) {
                    connection = result;
                }
            }));
            return future;
        }

        public Future<HttpPacket> get(HttpPacket request) throws IOException {
            SafeFutureImpl localFuture;
            this.asyncFuture = localFuture = SafeFutureImpl.create();
            this.connection.write((Object)request, (CompletionHandler)new EmptyCompletionHandler((FutureImpl)localFuture){
                final /* synthetic */ FutureImpl val$localFuture;
                {
                    this.val$localFuture = futureImpl;
                }

                public void failed(Throwable throwable) {
                    this.val$localFuture.failure(throwable);
                }
            });
            this.connection.addCloseListener((CloseListener)new GenericCloseListener(){
                final /* synthetic */ FutureImpl val$localFuture;
                {
                    this.val$localFuture = futureImpl;
                }

                public void onClosed(Closeable closeable, CloseType type) throws IOException {
                    this.val$localFuture.failure((Throwable)new IOException());
                }
            });
            return localFuture;
        }

        public void close() throws IOException {
            if (this.connection != null) {
                this.connection.close();
            }
        }

        private class HttpResponseFilter
        extends BaseFilter {
            private HttpResponseFilter() {
            }

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                HttpContent message = (HttpContent)ctx.getMessage();
                if (message.isLast()) {
                    FutureImpl localFuture = HttpClient.this.asyncFuture;
                    HttpClient.this.asyncFuture = null;
                    localFuture.result((Object)message);
                    return ctx.getStopAction();
                }
                return ctx.getStopAction((Object)message);
            }
        }
    }
}

