/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.npn.ClientSideNegotiator;
import org.glassfish.grizzly.npn.NegotiationSupport;
import org.glassfish.grizzly.npn.ServerSideNegotiator;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLUtils;

public class NextProtoNegSupport {
    private static final Logger LOGGER = Grizzly.logger(NextProtoNegSupport.class);
    private static final Map<SSLEngine, Connection> SSL_TO_CONNECTION_MAP = new WeakHashMap<SSLEngine, Connection>();
    private static final NextProtoNegSupport INSTANCE;
    private final Map<Object, ServerSideNegotiator> serverSideNegotiators = new WeakHashMap<Object, ServerSideNegotiator>();
    private final ReadWriteLock serverSideLock = new ReentrantReadWriteLock();
    private final Map<Object, ClientSideNegotiator> clientSideNegotiators = new WeakHashMap<Object, ClientSideNegotiator>();
    private final ReadWriteLock clientSideLock = new ReentrantReadWriteLock();
    private final SSLBaseFilter.HandshakeListener handshakeListener = new SSLBaseFilter.HandshakeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStart(Connection connection) {
            final SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
            assert (sslEngine != null);
            if (sslEngine.getUseClientMode()) {
                ClientSideNegotiator negotiator;
                NextProtoNegSupport.this.clientSideLock.readLock().lock();
                try {
                    negotiator = (ClientSideNegotiator)NextProtoNegSupport.this.clientSideNegotiators.get(connection);
                    if (negotiator == null) {
                        negotiator = (ClientSideNegotiator)NextProtoNegSupport.this.clientSideNegotiators.get(connection.getTransport());
                    }
                }
                finally {
                    NextProtoNegSupport.this.clientSideLock.readLock().unlock();
                }
                if (negotiator != null) {
                    connection.addCloseListener(new CloseListener(){

                        public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                            NegotiationSupport.removeClientNegotiator(sslEngine);
                        }
                    });
                    NextProtoNegSupport.setConnection(sslEngine, connection);
                    NegotiationSupport.addNegotiator(sslEngine, negotiator);
                }
            } else {
                ServerSideNegotiator negotiator;
                NextProtoNegSupport.this.serverSideLock.readLock().lock();
                try {
                    negotiator = (ServerSideNegotiator)NextProtoNegSupport.this.serverSideNegotiators.get(connection);
                    if (negotiator == null) {
                        negotiator = (ServerSideNegotiator)NextProtoNegSupport.this.serverSideNegotiators.get(connection.getTransport());
                    }
                }
                finally {
                    NextProtoNegSupport.this.serverSideLock.readLock().unlock();
                }
                if (negotiator != null) {
                    connection.addCloseListener(new CloseListener(){

                        public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                            NegotiationSupport.removeServerNegotiator(sslEngine);
                        }
                    });
                    NextProtoNegSupport.setConnection(sslEngine, connection);
                    NegotiationSupport.addNegotiator(sslEngine, negotiator);
                }
            }
        }

        @Override
        public void onComplete(Connection connection) {
        }

        @Override
        public void onFailure(Connection connection, Throwable t) {
        }
    };

    public static boolean isEnabled() {
        return INSTANCE != null;
    }

    public static NextProtoNegSupport getInstance() {
        if (!NextProtoNegSupport.isEnabled()) {
            throw new IllegalStateException("TLS Next Protocol Negotiation is disabled");
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(SSLEngine engine) {
        Map<SSLEngine, Connection> map = SSL_TO_CONNECTION_MAP;
        synchronized (map) {
            return SSL_TO_CONNECTION_MAP.get(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConnection(SSLEngine engine, Connection connection) {
        Map<SSLEngine, Connection> map = SSL_TO_CONNECTION_MAP;
        synchronized (map) {
            SSL_TO_CONNECTION_MAP.put(engine, connection);
        }
    }

    private NextProtoNegSupport() {
    }

    public void configure(SSLBaseFilter sslFilter) {
        sslFilter.addHandshakeListener(this.handshakeListener);
    }

    public void setServerSideNegotiator(Transport transport, ServerSideNegotiator negotiator) {
        this.putServerSideNegotiator(transport, negotiator);
    }

    public void setServerSideNegotiator(Connection connection, ServerSideNegotiator negotiator) {
        this.putServerSideNegotiator(connection, negotiator);
    }

    public void setClientSideNegotiator(Transport transport, ClientSideNegotiator negotiator) {
        this.putClientSideNegotiator(transport, negotiator);
    }

    public void setClientSideNegotiator(Connection connection, ClientSideNegotiator negotiator) {
        this.putClientSideNegotiator(connection, negotiator);
    }

    private void putServerSideNegotiator(Object object, ServerSideNegotiator negotiator) {
        this.serverSideLock.writeLock().lock();
        try {
            this.serverSideNegotiators.put(object, negotiator);
        }
        finally {
            this.serverSideLock.writeLock().unlock();
        }
    }

    private void putClientSideNegotiator(Object object, ClientSideNegotiator negotiator) {
        this.clientSideLock.writeLock().lock();
        try {
            this.clientSideNegotiators.put(object, negotiator);
        }
        finally {
            this.clientSideLock.writeLock().unlock();
        }
    }

    static {
        boolean isExtensionFound = false;
        try {
            ClassLoader.getSystemClassLoader().loadClass("sun.security.ssl.GrizzlyNPN");
            isExtensionFound = true;
        }
        catch (Throwable e) {
            LOGGER.log(Level.FINE, "TLS Next Protocol Negotiation extension is not found:", e);
        }
        INSTANCE = isExtensionFound ? new NextProtoNegSupport() : null;
    }
}

