/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.function.Supplier;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

class MuleLoggerProvider {
    private static final String DISABLE_LOG_SEPARATION_PROPERTY = "mule.disableLogSeparation";
    private static final String USE_SLF4J_PROPERTY = "mule.grizzly.useSLF4J";
    private static final boolean isMuleLogSeparationEnabled = System.getProperty("mule.disableLogSeparation") == null;
    private static final boolean useSlf4j = Boolean.parseBoolean(System.getProperty("mule.grizzly.useSLF4J", isMuleLogSeparationEnabled ? "false" : "true"));

    MuleLoggerProvider() {
    }

    public static Logger getLogger(String name) {
        return useSlf4j ? LoggerFactory.getLogger((String)name) : new JulAsSlf4jAdapter(name);
    }

    private static class JulAsSlf4jAdapter
    implements Logger {
        private final java.util.logging.Logger julDelegate;

        public JulAsSlf4jAdapter(String name) {
            this.julDelegate = java.util.logging.Logger.getLogger(name);
        }

        public String getName() {
            return this.julDelegate.getName();
        }

        public boolean isTraceEnabled() {
            return this.julDelegate.isLoggable(Level.FINEST);
        }

        public void trace(String msg) {
            this.julDelegate.log(Level.FINEST, msg);
        }

        public void trace(String format, Object arg) {
            this.julDelegate.log(Level.FINEST, new MessageSupplier(format, arg));
        }

        public void trace(String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.FINEST, new MessageSupplier(format, arg1, arg2));
        }

        public void trace(String format, Object ... arguments) {
            this.julDelegate.log(Level.FINEST, new MessageSupplier(format, arguments));
        }

        public void trace(String msg, Throwable t) {
            this.julDelegate.log(Level.FINEST, msg, t);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.julDelegate.isLoggable(Level.FINEST);
        }

        public void trace(Marker marker, String msg) {
            this.julDelegate.log(Level.FINEST, msg);
        }

        public void trace(Marker marker, String format, Object arg) {
            this.julDelegate.log(Level.FINEST, new MessageSupplier(format, arg));
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.FINEST, new MessageSupplier(format, arg1, arg2));
        }

        public void trace(Marker marker, String format, Object ... arguments) {
            this.julDelegate.log(Level.FINEST, new MessageSupplier(format, arguments));
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.julDelegate.log(Level.FINEST, msg, t);
        }

        public boolean isDebugEnabled() {
            return this.julDelegate.isLoggable(Level.FINE);
        }

        public void debug(String msg) {
            this.julDelegate.log(Level.FINE, msg);
        }

        public void debug(String format, Object arg) {
            this.julDelegate.log(Level.FINE, new MessageSupplier(format, arg));
        }

        public void debug(String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.FINE, new MessageSupplier(format, arg1, arg2));
        }

        public void debug(String format, Object ... arguments) {
            this.julDelegate.log(Level.FINE, new MessageSupplier(format, arguments));
        }

        public void debug(String msg, Throwable t) {
            this.julDelegate.log(Level.FINE, msg, t);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.julDelegate.isLoggable(Level.FINE);
        }

        public void debug(Marker marker, String msg) {
            this.julDelegate.log(Level.FINE, msg);
        }

        public void debug(Marker marker, String format, Object arg) {
            this.julDelegate.log(Level.FINE, new MessageSupplier(format, arg));
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.FINE, new MessageSupplier(format, arg1, arg2));
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            this.julDelegate.log(Level.FINE, new MessageSupplier(format, arguments));
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.julDelegate.log(Level.FINE, msg, t);
        }

        public boolean isInfoEnabled() {
            return this.julDelegate.isLoggable(Level.INFO);
        }

        public void info(String msg) {
            this.julDelegate.log(Level.INFO, msg);
        }

        public void info(String format, Object arg) {
            this.julDelegate.log(Level.INFO, new MessageSupplier(format, arg));
        }

        public void info(String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.INFO, new MessageSupplier(format, arg1, arg2));
        }

        public void info(String format, Object ... arguments) {
            this.julDelegate.log(Level.INFO, new MessageSupplier(format, arguments));
        }

        public void info(String msg, Throwable t) {
            this.julDelegate.log(Level.INFO, msg, t);
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.julDelegate.isLoggable(Level.INFO);
        }

        public void info(Marker marker, String msg) {
            this.julDelegate.log(Level.INFO, msg);
        }

        public void info(Marker marker, String format, Object arg) {
            this.julDelegate.log(Level.INFO, new MessageSupplier(format, arg));
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.INFO, new MessageSupplier(format, arg1, arg2));
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.julDelegate.log(Level.INFO, new MessageSupplier(format, arguments));
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.julDelegate.log(Level.INFO, msg, t);
        }

        public boolean isWarnEnabled() {
            return this.julDelegate.isLoggable(Level.WARNING);
        }

        public void warn(String msg) {
            this.julDelegate.log(Level.WARNING, msg);
        }

        public void warn(String format, Object arg) {
            this.julDelegate.log(Level.WARNING, new MessageSupplier(format, arg));
        }

        public void warn(String format, Object ... arguments) {
            this.julDelegate.log(Level.WARNING, new MessageSupplier(format, arguments));
        }

        public void warn(String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.WARNING, new MessageSupplier(format, arg1, arg2));
        }

        public void warn(String msg, Throwable t) {
            this.julDelegate.log(Level.WARNING, msg, t);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.julDelegate.isLoggable(Level.WARNING);
        }

        public void warn(Marker marker, String msg) {
            this.julDelegate.log(Level.WARNING, msg);
        }

        public void warn(Marker marker, String format, Object arg) {
            this.julDelegate.log(Level.WARNING, new MessageSupplier(format, arg));
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.WARNING, new MessageSupplier(format, arg1, arg2));
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.julDelegate.log(Level.WARNING, new MessageSupplier(format, arguments));
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.julDelegate.log(Level.WARNING, msg, t);
        }

        public boolean isErrorEnabled() {
            return this.julDelegate.isLoggable(Level.SEVERE);
        }

        public void error(String msg) {
            this.julDelegate.log(Level.SEVERE, msg);
        }

        public void error(String format, Object arg) {
            this.julDelegate.log(Level.SEVERE, new MessageSupplier(format, arg));
        }

        public void error(String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.SEVERE, new MessageSupplier(format, arg1, arg2));
        }

        public void error(String format, Object ... arguments) {
            this.julDelegate.log(Level.SEVERE, new MessageSupplier(format, arguments));
        }

        public void error(String msg, Throwable t) {
            this.julDelegate.log(Level.SEVERE, msg, t);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.julDelegate.isLoggable(Level.SEVERE);
        }

        public void error(Marker marker, String msg) {
            this.julDelegate.log(Level.SEVERE, msg);
        }

        public void error(Marker marker, String format, Object arg) {
            this.julDelegate.log(Level.SEVERE, new MessageSupplier(format, arg));
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.julDelegate.log(Level.SEVERE, new MessageSupplier(format, arg1, arg2));
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.julDelegate.log(Level.SEVERE, new MessageSupplier(format, arguments));
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.julDelegate.log(Level.SEVERE, msg, t);
        }
    }

    private static class MessageSupplier
    implements Supplier<String> {
        private final Supplier<String> delegate;

        public MessageSupplier(final String format, final Object arg) {
            this.delegate = new Supplier<String>(){

                @Override
                public String get() {
                    return MessageFormatter.format((String)format, (Object)arg).getMessage();
                }
            };
        }

        public MessageSupplier(final String format, final Object ... arguments) {
            this.delegate = new Supplier<String>(){

                @Override
                public String get() {
                    return MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
                }
            };
        }

        public MessageSupplier(final String format, final Object arg1, final Object arg2) {
            this.delegate = new Supplier<String>(){

                @Override
                public String get() {
                    return MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
                }
            };
        }

        @Override
        public String get() {
            return this.delegate.get();
        }
    }
}

