/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet.extras;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.io.NIOReader;
import org.glassfish.grizzly.http.multipart.ContentDisposition;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.multipart.MultipartEntryHandler;
import org.glassfish.grizzly.http.multipart.MultipartScanner;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.Parameters;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.slf4j.Logger;

public class MultipartUploadFilter
implements Filter {
    public static final String DELETE_ON_REQUEST_END = "org.glassfish.grizzly.multipart.DELETE_ON_REQUEST_END";
    public static final String UPLOADED_FILES = "org.glassfish.grizzly.multipart.UPLOADED_FILES";
    private static final Logger LOGGER = Grizzly.logger(MultipartUploadFilter.class);
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String MULTIPART_FORM = "multipart/form-data";
    private boolean deleteAfterRequestEnd = true;
    private File tempDir;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String delete = filterConfig.getInitParameter(DELETE_ON_REQUEST_END);
        if (delete != null) {
            this.deleteAfterRequestEnd = Boolean.getBoolean(delete);
        }
        File baseTempDir = new File(System.getProperty(JAVA_IO_TMPDIR));
        this.tempDir = new File(baseTempDir, Long.toString(System.currentTimeMillis()));
        this.tempDir.deleteOnExit();
    }

    @Override
    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain) throws IOException, ServletException {
        String contentType = servletRequest.getContentType();
        if (contentType == null || !contentType.startsWith(MULTIPART_FORM)) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        MultipartUploadFilter.validateRequestResponse(servletRequest, servletResponse);
        String dirName = Long.toString(System.nanoTime());
        final File dir = new File(this.tempDir, dirName);
        Request request = ((HttpServletRequestImpl)servletRequest).getRequest();
        final Response response = ((HttpServletResponseImpl)servletResponse).getResponse();
        response.suspend();
        final ArrayList<File> uploadedFiles = new ArrayList<File>();
        final Parameters formParams = new Parameters();
        UploadMultipartHandler uploadHandler = new UploadMultipartHandler(uploadedFiles, dir, formParams);
        MultipartScanner.scan(request, (MultipartEntryHandler)uploadHandler, (CompletionHandler<Request>)new EmptyCompletionHandler<Request>(){

            @Override
            public void completed(Request request) {
                request.setRequestParameters(formParams);
                servletRequest.setAttribute(MultipartUploadFilter.UPLOADED_FILES, uploadedFiles.toArray(new File[uploadedFiles.size()]));
                try {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
                catch (Exception e) {
                    LOGGER.error(e.toString(), (Throwable)e);
                }
                finally {
                    if (MultipartUploadFilter.this.deleteAfterRequestEnd) {
                        MultipartUploadFilter.clean(dir);
                    }
                    response.resume();
                }
            }

            @Override
            public void failed(Throwable throwable) {
                LOGGER.error("Upload failed.", throwable);
                response.resume();
            }
        });
    }

    @Override
    public void destroy() {
        MultipartUploadFilter.clean(this.tempDir);
    }

    private static void validateRequestResponse(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException {
        if (!(servletRequest instanceof HttpServletRequestImpl)) {
            throw new ServletException("ServletRequest instances passed to MultipartUploadFilter must not be wrapped.");
        }
        if (!(servletResponse instanceof HttpServletResponseImpl)) {
            throw new ServletException("ServletResponse instances passed to MultipartUploadFilter must not be wrapped.");
        }
    }

    private static void clean(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] f = file.listFiles();
            if (f.length == 0) {
                if (!file.delete() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unable to delete directory {}.  Will attempt deletion again upon JVM exit.", (Object)file.getAbsolutePath());
                }
            } else {
                for (File ff : f) {
                    MultipartUploadFilter.clean(ff);
                }
            }
        } else if (!file.delete()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unable to delete file {}.  Will attempt deletion again upon JVM exit.", (Object)file.getAbsolutePath());
            }
            file.deleteOnExit();
        }
    }

    private static final class UploadMultipartHandler
    implements MultipartEntryHandler {
        private final AtomicInteger uploadedBytesCounter = new AtomicInteger();
        private final File uploadDir;
        private final List<File> uploadedFiles;
        private final Parameters formParams;

        public UploadMultipartHandler(List<File> uploadedFiles, File uploadDir, Parameters formParams) {
            this.uploadedFiles = uploadedFiles;
            this.uploadDir = uploadDir;
            this.formParams = formParams;
        }

        @Override
        public void handle(MultipartEntry multipartEntry) throws Exception {
            ContentDisposition contentDisposition = multipartEntry.getContentDisposition();
            final String paramName = contentDisposition.getDispositionParamUnquoted("name");
            String filename = contentDisposition.getDispositionParamUnquoted("filename");
            if (filename != null && filename.length() > 0) {
                this.formParams.addParameterValues(paramName, new String[]{filename});
                NIOInputStream inputStream = multipartEntry.getNIOInputStream();
                LOGGER.debug("Uploading file {}", (Object)filename);
                inputStream.notifyAvailable(new UploadReadHandler(this.uploadedFiles, this.uploadDir, filename, inputStream, this.uploadedBytesCounter));
            } else {
                final NIOReader nioReader = multipartEntry.getNIOReader();
                nioReader.notifyAvailable(new ReadHandler(){

                    @Override
                    public void onDataAvailable() throws Exception {
                    }

                    @Override
                    public void onError(Throwable t) {
                        try {
                            nioReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void onAllDataRead() throws Exception {
                        char[] chars = new char[nioReader.readyData()];
                        nioReader.read(chars);
                        formParams.addParameterValues(paramName, new String[]{new String(chars)});
                    }
                });
            }
        }
    }

    private static class UploadReadHandler
    implements ReadHandler {
        private final NIOInputStream inputStream;
        private final FileChannel fileOutput;
        private final String filename;
        private final AtomicInteger uploadedBytesCounter;
        private final File uploadFile;
        private final List<File> uploadedFiles;

        private UploadReadHandler(List<File> uploadedFiles, File uploadDir, String filename, NIOInputStream inputStream, AtomicInteger uploadedBytesCounter) throws FileNotFoundException {
            this.uploadedFiles = uploadedFiles;
            this.filename = filename;
            if (!uploadDir.exists() && !uploadDir.mkdirs()) {
                throw new RuntimeException(String.format("Unable to create directory %s", uploadDir.toString()));
            }
            this.uploadFile = new File(uploadDir, filename);
            this.fileOutput = new FileOutputStream(this.uploadFile).getChannel();
            this.inputStream = inputStream;
            this.uploadedBytesCounter = uploadedBytesCounter;
        }

        @Override
        public void onDataAvailable() throws Exception {
            this.readAndSaveAvail();
            this.inputStream.notifyAvailable(this);
        }

        @Override
        public void onAllDataRead() throws Exception {
            this.readAndSaveAvail();
            this.finish();
        }

        @Override
        public void onError(Throwable t) {
            LOGGER.warn("Upload of file {} failed.", (Object)this.filename, (Object)t);
            this.finish();
        }

        private void readAndSaveAvail() throws IOException {
            while (this.inputStream.isReady()) {
                Buffer buffer = this.inputStream.readBuffer();
                if (buffer.isComposite()) {
                    this.writeCompositeBuffer(buffer);
                    continue;
                }
                this.writeBufferToDiskAndUpdateStats(buffer.toByteBuffer());
            }
        }

        private void writeCompositeBuffer(Buffer b) throws IOException {
            ByteBufferArray bufferArray = b.toByteBufferArray();
            ByteBuffer[] buffers = (ByteBuffer[])bufferArray.getArray();
            int len = bufferArray.size();
            for (int i = 0; i < len; ++i) {
                this.writeBufferToDiskAndUpdateStats(buffers[i]);
            }
        }

        private void writeBufferToDiskAndUpdateStats(ByteBuffer b) throws IOException {
            this.uploadedBytesCounter.addAndGet(b.remaining());
            this.fileOutput.write(b);
        }

        private void finish() {
            try {
                this.fileOutput.close();
                this.uploadedFiles.add(this.uploadFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

