/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.compression.Utils;

public class SpdyDeflaterOutputStream
extends OutputStream {
    private final Deflater deflater;
    private final MemoryManager mm;
    private final byte[] tmpBA = new byte[1];
    private CompositeBuffer compositeBuffer;
    private Buffer currentOutputBuffer;
    private Buffer prevOutputBuffer;
    private byte[] tmpInBuffer;
    private byte[] tmpOutBuffer;
    private int bufferSize = 2048;
    private boolean closed = false;
    private final boolean isUsingOwnDeflater;

    public SpdyDeflaterOutputStream(MemoryManager mm, int level) {
        this.mm = mm;
        this.deflater = new Deflater(level);
        Utils.setSpdyCompressionDictionary(this.deflater);
        this.isUsingOwnDeflater = true;
    }

    public SpdyDeflaterOutputStream(MemoryManager mm, Deflater deflater) {
        this.mm = mm;
        this.deflater = deflater;
        this.isUsingOwnDeflater = false;
    }

    public Deflater getDeflater() {
        return this.deflater;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setInitialOutputBuffer(Buffer buffer) {
        if (this.currentOutputBuffer != null) {
            throw new IllegalStateException("Can't set initial buffer in the middle of deflate");
        }
        this.currentOutputBuffer = buffer;
    }

    public Buffer checkpoint() {
        if (!this.deflater.finished()) {
            this.deflate(2);
        }
        if (this.currentOutputBuffer != null) {
            this.currentOutputBuffer.trim();
        }
        CompositeBuffer cpb = this.compositeBuffer;
        Buffer pb = this.prevOutputBuffer;
        Buffer cb = this.currentOutputBuffer;
        this.compositeBuffer = null;
        this.currentOutputBuffer = null;
        this.prevOutputBuffer = null;
        if (cpb != null) {
            cpb.append(pb);
            if (cb.hasRemaining()) {
                cpb.append(cb);
            }
            return cpb;
        }
        if (pb != null) {
            if (cb.hasRemaining()) {
                return CompositeBuffer.newBuffer((MemoryManager)this.mm, (Buffer[])new Buffer[]{pb, cb});
            }
            return pb;
        }
        return cb;
    }

    @Override
    public void write(int b) throws IOException {
        this.tmpBA[0] = (byte)b;
        this.write(this.tmpBA, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.deflater.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (!this.deflater.finished()) {
            this.deflater.setInput(b, off, len);
            while (!this.deflater.needsInput()) {
                this.deflate();
            }
        }
    }

    public void write(Buffer buffer) throws IOException {
        if (buffer.hasArray()) {
            this.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else if (buffer.isComposite()) {
            BufferArray bufferArray = buffer.toBufferArray();
            Buffer[] array = (Buffer[])bufferArray.getArray();
            for (int i = 0; i < bufferArray.size(); ++i) {
                this.writeSimpleBuffer(array[i]);
            }
        } else {
            this.writeSimpleBuffer(buffer);
        }
        buffer.position(buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSimpleBuffer(Buffer buffer) throws IOException {
        assert (!buffer.isComposite());
        if (buffer.hasArray()) {
            this.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            int oldPos = buffer.position();
            try {
                int chunkSize;
                byte[] tmpInput = this.getTmpInputArray();
                for (int remaining = buffer.remaining(); remaining > 0; remaining -= chunkSize) {
                    chunkSize = Math.min(remaining, tmpInput.length);
                    buffer.get(tmpInput, 0, chunkSize);
                    this.write(tmpInput, 0, chunkSize);
                }
            }
            finally {
                buffer.position(oldPos);
            }
        }
    }

    protected int deflate() {
        return this.deflate(0);
    }

    protected int deflate(int flush) {
        if (this.currentOutputBuffer == null) {
            this.currentOutputBuffer = this.mm.allocate(this.bufferSize);
        } else if (!this.currentOutputBuffer.hasRemaining()) {
            this.currentOutputBuffer.flip();
            if (this.prevOutputBuffer != null) {
                if (this.compositeBuffer == null) {
                    this.compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)this.mm, (Buffer[])new Buffer[]{this.prevOutputBuffer});
                } else {
                    this.compositeBuffer.append(this.prevOutputBuffer);
                }
            }
            this.prevOutputBuffer = this.currentOutputBuffer;
            this.currentOutputBuffer = this.mm.allocate(this.bufferSize);
        }
        if (this.currentOutputBuffer.hasArray()) {
            int position = this.currentOutputBuffer.position();
            int n = this.deflater.deflate(this.currentOutputBuffer.array(), this.currentOutputBuffer.arrayOffset() + position, this.currentOutputBuffer.remaining(), flush);
            if (n > 0) {
                this.currentOutputBuffer.position(position + n);
            }
            return n;
        }
        this.tmpOutBuffer = this.getTmpOutputArray();
        int n = this.deflater.deflate(this.tmpOutBuffer, 0, this.tmpOutBuffer.length, flush);
        if (n > 0) {
            this.currentOutputBuffer.put(this.tmpOutBuffer, 0, n);
        }
        return n;
    }

    @Override
    public void flush() throws IOException {
    }

    public void finish() throws IOException {
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
    }

    public void closeStreamOnly() {
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            if (this.isUsingOwnDeflater) {
                this.deflater.end();
            }
            this.closed = true;
        }
    }

    public void reset() {
        this.deflater.reset();
        this.closed = false;
    }

    private byte[] getTmpOutputArray() {
        if (this.tmpOutBuffer == null || this.tmpOutBuffer.length < this.bufferSize) {
            this.tmpOutBuffer = new byte[this.bufferSize];
        }
        return this.tmpOutBuffer;
    }

    private byte[] getTmpInputArray() {
        if (this.tmpInBuffer == null || this.tmpInBuffer.length < this.bufferSize) {
            this.tmpInBuffer = new byte[this.bufferSize];
        }
        return this.tmpInBuffer;
    }
}

