/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.HeadersProviderFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class SynStreamFrame
extends HeadersProviderFrame {
    private static final ThreadCache.CachedTypeIndex<SynStreamFrame> CACHE_IDX = ThreadCache.obtainIndex(SynStreamFrame.class, (int)8);
    public static final int TYPE = 1;
    public static final byte FLAG_FIN = 1;
    public static final byte FLAG_UNIDIRECTIONAL = 2;
    protected int streamId;
    protected int associatedToStreamId;
    protected int priority;
    protected int slot;

    private SynStreamFrame() {
    }

    static SynStreamFrame create() {
        SynStreamFrame frame = (SynStreamFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new SynStreamFrame();
        }
        return frame;
    }

    static SynStreamFrame create(SpdyHeader header) {
        SynStreamFrame frame = SynStreamFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static SynStreamFrameBuilder builder() {
        return new SynStreamFrameBuilder();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getAssociatedToStreamId() {
        return this.associatedToStreamId;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSlot() {
        return this.slot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SynStreamFrame");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", associatedToStreamId=").append(this.associatedToStreamId);
        sb.append(", priority=").append(this.priority);
        sb.append(", slot=").append(this.slot);
        sb.append(", compressedHeaders=").append(this.compressedHeaders);
        sb.append(", fin=").append(this.isFlagSet((byte)1));
        sb.append(", unidirectional=").append(this.isFlagSet((byte)2));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.streamId = 0;
        this.associatedToStreamId = 0;
        this.priority = 0;
        this.slot = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Buffer frameBuffer = memoryManager.allocate(18);
        frameBuffer.putInt(-2147287039);
        frameBuffer.putInt(this.flags << 24 | this.compressedHeaders.remaining() + 10);
        frameBuffer.putInt(this.streamId & Integer.MAX_VALUE);
        frameBuffer.putInt(this.associatedToStreamId & Integer.MAX_VALUE);
        frameBuffer.putShort((short)(this.priority << 13 | this.slot & 0xFF));
        frameBuffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer((MemoryManager)memoryManager, (Buffer[])new Buffer[]{frameBuffer});
        cb.append(this.compressedHeaders);
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.streamId = header.buffer.getInt() & Integer.MAX_VALUE;
        this.associatedToStreamId = header.buffer.getInt() & Integer.MAX_VALUE;
        int tmpInt = header.buffer.getShort() & 0xFFFF;
        this.priority = tmpInt >> 13;
        this.slot = tmpInt & 0xFF;
    }

    public static class SynStreamFrameBuilder
    extends HeadersProviderFrame.HeadersProviderFrameBuilder<SynStreamFrameBuilder> {
        private final SynStreamFrame synStreamFrame;

        protected SynStreamFrameBuilder() {
            super(SynStreamFrame.create());
            this.synStreamFrame = (SynStreamFrame)this.frame;
        }

        public SynStreamFrameBuilder streamId(int streamId) {
            this.synStreamFrame.streamId = streamId;
            return this;
        }

        public SynStreamFrameBuilder associatedStreamId(int associatedStreamId) {
            this.synStreamFrame.associatedToStreamId = associatedStreamId;
            return this;
        }

        public SynStreamFrameBuilder priority(int priority) {
            this.synStreamFrame.priority = priority;
            return this;
        }

        public SynStreamFrameBuilder slot(int slot) {
            this.synStreamFrame.slot = slot;
            return this;
        }

        public SynStreamFrameBuilder unidirectional(boolean unidirectional) {
            if (unidirectional) {
                this.synStreamFrame.setFlag((byte)2);
            } else {
                this.synStreamFrame.clearFlag((byte)2);
            }
            return this;
        }

        public SynStreamFrameBuilder last(boolean last) {
            if (last) {
                this.synStreamFrame.setFlag((byte)1);
            } else {
                this.synStreamFrame.clearFlag((byte)1);
            }
            return this;
        }

        public SynStreamFrame build() {
            return this.synStreamFrame;
        }

        @Override
        protected SynStreamFrameBuilder getThis() {
            return this;
        }
    }
}

