/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.spdy.SpdyHeader;
import org.glassfish.grizzly.spdy.SpdyStream;

class SpdyResponse
extends HttpResponsePacket
implements SpdyHeader {
    private static final ThreadCache.CachedTypeIndex<SpdyResponseRecyclable> CACHE_IDX = ThreadCache.obtainIndex(SpdyResponseRecyclable.class, (int)2);
    private boolean contentTypeParsed;

    SpdyResponse() {
    }

    public static SpdyResponse create() {
        SpdyResponse spdyResponse = (SpdyResponse)ThreadCache.takeFromCache(CACHE_IDX);
        if (spdyResponse == null) {
            spdyResponse = new SpdyResponse();
        }
        return spdyResponse;
    }

    public ProcessingState getProcessingState() {
        return this.getRequest().getProcessingState();
    }

    @Override
    public SpdyStream getSpdyStream() {
        return SpdyStream.getSpdyStream((HttpHeader)this);
    }

    public String getCharacterEncoding() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        super.setCharacterEncoding(charset);
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getContentType();
    }

    private void parseContentTypeHeader() {
        DataChunk dc;
        this.contentTypeParsed = true;
        if (!this.contentType.isSet() && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
            this.setContentType(dc.toString());
        }
    }

    @Override
    public void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    protected void reset() {
        this.contentTypeParsed = false;
        super.reset();
    }

    private static class SpdyResponseRecyclable
    extends SpdyResponse {
        private SpdyResponseRecyclable() {
        }

        public void recycle() {
            this.reset();
            ThreadCache.putToCache((ThreadCache.CachedTypeIndex)CACHE_IDX, (Object)this);
        }
    }
}

