/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.HeadersProviderFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class SynReplyFrame
extends HeadersProviderFrame {
    private static final ThreadCache.CachedTypeIndex<SynReplyFrame> CACHE_IDX = ThreadCache.obtainIndex(SynReplyFrame.class, (int)8);
    public static final int TYPE = 2;
    public static final byte FLAG_FIN = 1;
    private int streamId;

    private SynReplyFrame() {
    }

    static SynReplyFrame create() {
        SynReplyFrame frame = (SynReplyFrame)ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new SynReplyFrame();
        }
        return frame;
    }

    static SynReplyFrame create(SpdyHeader header) {
        SynReplyFrame frame = SynReplyFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static SynReplyFrameBuilder builder() {
        return new SynReplyFrameBuilder();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SynReplyFrame");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", compressedHeaders=").append(this.compressedHeaders);
        sb.append(", fin=").append(this.isFlagSet((byte)1));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.streamId = 0;
        super.recycle();
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Buffer frameBuffer = memoryManager.allocate(12);
        frameBuffer.putInt(-2147287038);
        frameBuffer.putInt(this.flags << 24 | this.compressedHeaders.remaining() + 4);
        frameBuffer.putInt(this.streamId & Integer.MAX_VALUE);
        frameBuffer.trim();
        CompositeBuffer cb = CompositeBuffer.newBuffer((MemoryManager)memoryManager, (Buffer[])new Buffer[]{frameBuffer});
        cb.append(this.compressedHeaders);
        cb.allowBufferDispose(true);
        cb.allowInternalBuffersDispose(true);
        return cb;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.streamId = header.buffer.getInt() & Integer.MAX_VALUE;
    }

    public static class SynReplyFrameBuilder
    extends HeadersProviderFrame.HeadersProviderFrameBuilder<SynReplyFrameBuilder> {
        private final SynReplyFrame synReplyFrame;

        protected SynReplyFrameBuilder() {
            super(SynReplyFrame.create());
            this.synReplyFrame = (SynReplyFrame)this.frame;
        }

        public SynReplyFrameBuilder streamId(int streamId) {
            this.synReplyFrame.streamId = streamId;
            return this;
        }

        public SynReplyFrameBuilder last(boolean last) {
            if (last) {
                this.synReplyFrame.setFlag((byte)1);
            } else {
                this.synReplyFrame.clearFlag((byte)1);
            }
            return this;
        }

        public SynReplyFrame build() {
            return this.synReplyFrame;
        }

        @Override
        protected SynReplyFrameBuilder getThis() {
            return this;
        }
    }
}

