/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.compression.Utils;

public class SpdyInflaterOutputStream
extends OutputStream {
    private final Inflater inflater;
    private final MemoryManager mm;
    private final byte[] tmpBA = new byte[1];
    private CompositeBuffer compositeBuffer;
    private Buffer currentOutputBuffer;
    private Buffer prevOutputBuffer;
    private byte[] tmpInBuffer;
    private byte[] tmpOutBuffer;
    private int bufferSize = 2048;
    private boolean closed = false;

    public SpdyInflaterOutputStream(MemoryManager mm) {
        this.mm = mm;
        this.inflater = new Inflater();
    }

    public Inflater getInflater() {
        return this.inflater;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Buffer checkpoint() {
        if (this.currentOutputBuffer != null) {
            this.currentOutputBuffer.trim();
        }
        CompositeBuffer cpb = this.compositeBuffer;
        Buffer pb = this.prevOutputBuffer;
        Buffer cb = this.currentOutputBuffer;
        this.compositeBuffer = null;
        this.currentOutputBuffer = null;
        this.prevOutputBuffer = null;
        if (cpb != null) {
            cpb.append(pb);
            if (cb.hasRemaining()) {
                cpb.append(cb);
            }
            return cpb;
        }
        if (pb != null) {
            if (cb.hasRemaining()) {
                return CompositeBuffer.newBuffer((MemoryManager)this.mm, (Buffer[])new Buffer[]{pb, cb});
            }
            return pb;
        }
        return cb;
    }

    @Override
    public void write(int b) throws IOException {
        this.tmpBA[0] = (byte)b;
        this.write(this.tmpBA, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Null buffer for read");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            while (true) {
                int n;
                if (this.inflater.needsInput()) {
                    if (len < 1) break;
                    int part = len < 512 ? len : 512;
                    this.inflater.setInput(b, off, part);
                    off += part;
                    len -= part;
                }
                while ((n = this.inflate()) > 0) {
                }
                if (!this.inflater.finished()) {
                    if (!this.inflater.needsDictionary()) continue;
                    Utils.setSpdyCompressionDictionary(this.inflater);
                    continue;
                }
                break;
            }
        }
        catch (DataFormatException ex) {
            String msg = ex.getMessage();
            if (msg == null) {
                msg = "Invalid ZLIB data format";
            }
            throw new ZipException(msg);
        }
    }

    public void write(Buffer buffer) throws IOException {
        if (buffer.hasArray()) {
            this.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else if (buffer.isComposite()) {
            BufferArray bufferArray = buffer.toBufferArray();
            Buffer[] array = (Buffer[])bufferArray.getArray();
            for (int i = 0; i < bufferArray.size(); ++i) {
                this.writeSimpleBuffer(array[i]);
            }
        } else {
            this.writeSimpleBuffer(buffer);
        }
        buffer.position(buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSimpleBuffer(Buffer buffer) throws IOException {
        assert (!buffer.isComposite());
        if (buffer.hasArray()) {
            this.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            int oldPos = buffer.position();
            try {
                int chunkSize;
                byte[] tmpInput = this.getTmpInputArray();
                for (int remaining = buffer.remaining(); remaining > 0; remaining -= chunkSize) {
                    chunkSize = Math.min(remaining, tmpInput.length);
                    buffer.get(tmpInput, 0, chunkSize);
                    this.write(tmpInput, 0, chunkSize);
                }
            }
            finally {
                buffer.position(oldPos);
            }
        }
    }

    protected int inflate() throws DataFormatException {
        if (this.currentOutputBuffer == null) {
            this.currentOutputBuffer = this.mm.allocate(this.bufferSize);
        } else if (!this.currentOutputBuffer.hasRemaining()) {
            this.currentOutputBuffer.flip();
            if (this.prevOutputBuffer != null) {
                if (this.compositeBuffer == null) {
                    this.compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)this.mm, (Buffer[])new Buffer[]{this.prevOutputBuffer});
                } else {
                    this.compositeBuffer.append(this.prevOutputBuffer);
                }
            }
            this.prevOutputBuffer = this.currentOutputBuffer;
            this.currentOutputBuffer = this.mm.allocate(this.bufferSize);
        }
        if (this.currentOutputBuffer.hasArray()) {
            int position = this.currentOutputBuffer.position();
            int n = this.inflater.inflate(this.currentOutputBuffer.array(), this.currentOutputBuffer.arrayOffset() + position, this.currentOutputBuffer.remaining());
            if (n > 0) {
                this.currentOutputBuffer.position(position + n);
            }
            return n;
        }
        this.tmpOutBuffer = this.getTmpOutputArray();
        int n = this.inflater.inflate(this.tmpOutBuffer, 0, this.tmpOutBuffer.length);
        if (n > 0) {
            this.currentOutputBuffer.put(this.tmpOutBuffer, 0, n);
        }
        return n;
    }

    @Override
    public void flush() throws IOException {
    }

    public void finish() throws IOException {
        this.ensureOpen();
        this.flush();
        this.inflater.end();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void reset() {
        this.inflater.reset();
        this.closed = false;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private byte[] getTmpOutputArray() {
        if (this.tmpOutBuffer == null || this.tmpOutBuffer.length < this.bufferSize) {
            this.tmpOutBuffer = new byte[this.bufferSize];
        }
        return this.tmpOutBuffer;
    }

    private byte[] getTmpInputArray() {
        if (this.tmpInBuffer == null || this.tmpInBuffer.length < this.bufferSize) {
            this.tmpInBuffer = new byte[this.bufferSize];
        }
        return this.tmpInBuffer;
    }
}

