/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.SpdySessionException;
import org.glassfish.grizzly.spdy.frames.CredentialFrame;
import org.glassfish.grizzly.spdy.frames.DataFrame;
import org.glassfish.grizzly.spdy.frames.GoAwayFrame;
import org.glassfish.grizzly.spdy.frames.HeadersFrame;
import org.glassfish.grizzly.spdy.frames.PingFrame;
import org.glassfish.grizzly.spdy.frames.RstStreamFrame;
import org.glassfish.grizzly.spdy.frames.SettingsFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;
import org.glassfish.grizzly.spdy.frames.SynReplyFrame;
import org.glassfish.grizzly.spdy.frames.SynStreamFrame;
import org.glassfish.grizzly.spdy.frames.WindowUpdateFrame;

public abstract class SpdyFrame
implements Cacheable {
    protected SpdyHeader header;
    protected int flags;

    protected SpdyFrame() {
    }

    public static SpdyFrame wrap(Buffer buffer) throws SpdySessionException {
        SpdyHeader header = SpdyHeader.wrap(buffer);
        if (header.control) {
            switch (header.type) {
                case 1: {
                    return SynStreamFrame.create(header);
                }
                case 2: {
                    return SynReplyFrame.create(header);
                }
                case 3: {
                    return RstStreamFrame.create(header);
                }
                case 4: {
                    return SettingsFrame.create(header);
                }
                case 6: {
                    return PingFrame.create(header);
                }
                case 7: {
                    return GoAwayFrame.create(header);
                }
                case 8: {
                    return HeadersFrame.create(header);
                }
                case 9: {
                    return WindowUpdateFrame.create(header);
                }
                case 10: {
                    return CredentialFrame.create(header);
                }
            }
            throw new SpdySessionException(header.getStreamId(), 1);
        }
        return DataFrame.create(header);
    }

    public boolean isFlagSet(byte flag) {
        return (this.flags & flag) == flag;
    }

    public void setFlag(byte flag) {
        if (this.header == null) {
            this.flags |= flag;
        }
    }

    public void clearFlag(byte flag) {
        if (this.header == null) {
            this.flags &= ~flag;
        }
    }

    public SpdyHeader getHeader() {
        return this.header;
    }

    public boolean isService() {
        return false;
    }

    public abstract Buffer toBuffer(MemoryManager var1);

    public void recycle() {
        if (this.header != null) {
            this.header.recycle();
            this.header = null;
        }
        this.flags = 0;
    }

    protected void initialize(SpdyHeader header) {
        this.header = header;
        this.flags = header.flags;
    }

    protected static abstract class SpdyFrameBuilder<T extends SpdyFrameBuilder> {
        protected final SpdyFrame frame;

        protected SpdyFrameBuilder(SpdyFrame frame) {
            this.frame = frame;
        }

        public T setFlag(byte flag) {
            this.frame.setFlag(flag);
            return this.getThis();
        }

        protected abstract T getThis();
    }
}

