/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpBrokenContent;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.utils.DataStructures;

final class StreamInputBuffer {
    private static final Logger LOGGER = Grizzly.logger(StreamInputBuffer.class);
    private static final long NULL_CONTENT_LENGTH = Long.MIN_VALUE;
    private final AtomicInteger inputQueueSize = new AtomicInteger();
    private final BlockingQueue<InputElement> inputQueue = DataStructures.getLTQInstance(InputElement.class);
    private final AtomicBoolean isInputClosed = new AtomicBoolean();
    private final AtomicReference<SpdyStream.Termination> closeFlag = new AtomicReference();
    private final Object terminateSync = new Object();
    private final SpdyStream spdyStream;
    private final SpdySession spdySession;
    private final Object expectInputSwitchSync = new Object();
    private boolean expectInputSwitch;
    private final AtomicInteger unackedReadBytes = new AtomicInteger();
    private long remainingContentLength = Long.MIN_VALUE;

    StreamInputBuffer(SpdyStream spdyStream) {
        this.spdyStream = spdyStream;
        this.spdySession = spdyStream.getSpdySession();
    }

    void onReadEventComplete() {
        if (this.spdyStream.isProcessingComplete || !this.spdyStream.getInputHttpHeader().isExpectContent()) {
            return;
        }
        if (this.isClosed()) {
            this.spdySession.sendMessageUpstream(this.spdyStream, (HttpPacket)this.buildBrokenHttpContent(new EOFException(this.closeFlag.get().getDescription())));
            return;
        }
        this.switchOnExpectInput();
        int queueSize = this.switchOffExpectInputIfQueueNotEmpty();
        if (queueSize > 0) {
            this.passPayloadUpstream(null, queueSize);
        }
    }

    boolean offer(Buffer data, boolean isLast) {
        if (this.isInputClosed.get()) {
            data.tryDispose();
            return false;
        }
        boolean isLastData = isLast | this.checkContentLength(data.remaining());
        InputElement element = new InputElement(data, isLastData, false);
        this.offer0(element);
        if (isLastData) {
            this.isInputClosed.set(true);
        }
        if (this.isClosed() && this.inputQueue.remove(element)) {
            data.tryDispose();
            return false;
        }
        return true;
    }

    private void offer0(InputElement inputElement) {
        if (this.switchOffExpectInput()) {
            this.passPayloadUpstream(inputElement, this.inputQueueSize.get());
        } else {
            if (!this.inputQueue.offer(inputElement)) {
                throw new IllegalStateException("New element can't be added");
            }
            this.inputQueueSize.incrementAndGet();
            int readyBuffersCount = this.switchOffExpectInputIfQueueNotEmpty();
            if (readyBuffersCount > 0) {
                this.passPayloadUpstream(null, readyBuffersCount);
            }
        }
    }

    private void passPayloadUpstream(InputElement inputElement, int readyBuffersCount) {
        try {
            if (readyBuffersCount == -1) {
                readyBuffersCount = this.inputQueueSize.get();
            }
            Buffer payload = null;
            if (readyBuffersCount > 0) {
                payload = this.poll0();
                assert (payload != null);
            }
            if (inputElement != null) {
                Buffer data = inputElement.toBuffer();
                if (!inputElement.isService) {
                    payload = Buffers.appendBuffers((MemoryManager)this.spdySession.getMemoryManager(), (Buffer)payload, (Buffer)data);
                    this.sendWindowUpdate(data);
                } else if (payload == null) {
                    payload = data;
                }
                this.checkEOF(inputElement);
            }
            HttpContent content = this.buildHttpContent(payload);
            this.spdySession.sendMessageUpstreamWithParseNotify(this.spdyStream, content);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unexpected IOException: {0}", e.getMessage());
        }
    }

    HttpContent poll() throws IOException {
        return this.buildHttpContent(this.poll0());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer poll0() throws IOException {
        Buffer buffer;
        if (this.isClosed()) {
            return Buffers.EMPTY_BUFFER;
        }
        Object object = this.terminateSync;
        synchronized (object) {
            int inputQueueSizeNow = this.inputQueueSize.getAndSet(0);
            if (inputQueueSizeNow <= 0) {
                InputElement inputElement;
                try {
                    inputElement = this.inputQueue.poll(this.spdySession.getConnection().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new IOException("Blocking read was interrupted");
                }
                if (inputElement == null) {
                    throw new IOException("Blocking read timeout");
                }
                this.inputQueueSize.addAndGet(inputQueueSizeNow - 1);
                this.checkEOF(inputElement);
                buffer = inputElement.toBuffer();
            } else if (inputQueueSizeNow == 1) {
                InputElement inputElement = (InputElement)this.inputQueue.poll();
                this.checkEOF(inputElement);
                buffer = inputElement.toBuffer();
            } else {
                CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)this.spdySession.getMemoryManager());
                for (int i = 0; i < inputQueueSizeNow; ++i) {
                    InputElement currentElement = (InputElement)this.inputQueue.poll();
                    this.checkEOF(currentElement);
                    if (!currentElement.isService) {
                        compositeBuffer.append(currentElement.toBuffer());
                    }
                    if (currentElement.isLast) break;
                }
                compositeBuffer.allowBufferDispose(true);
                compositeBuffer.allowInternalBuffersDispose(true);
                buffer = compositeBuffer;
            }
        }
        this.sendWindowUpdate(buffer);
        return buffer;
    }

    boolean close(SpdyStream.Termination termination) {
        if (this.isInputClosed.compareAndSet(false, true)) {
            this.offer0(new InputElement(termination, true, true));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(SpdyStream.Termination termination) {
        boolean isSet = this.closeFlag.compareAndSet(null, termination);
        if (this.isInputClosed.compareAndSet(false, true)) {
            this.offer0(new InputElement(termination, true, true));
        }
        if (isSet) {
            int szToRelease = 0;
            Object object = this.terminateSync;
            synchronized (object) {
                InputElement element;
                while ((element = (InputElement)this.inputQueue.poll()) != null) {
                    if (element.isService) continue;
                    Buffer buffer = element.toBuffer();
                    szToRelease += buffer.remaining();
                    buffer.tryDispose();
                }
            }
            if (szToRelease > 0) {
                this.spdySession.sendWindowUpdate(szToRelease);
            }
            this.spdyStream.onInputClosed();
        }
    }

    boolean isClosed() {
        return this.closeFlag.get() != null;
    }

    private void checkEOF(InputElement inputElement) {
        if (inputElement.isLast) {
            SpdyStream.Termination termination;
            SpdyStream.Termination termination2 = termination = !inputElement.isService ? Constants.IN_FIN_TERMINATION : (SpdyStream.Termination)inputElement.content;
            if (this.closeFlag.compareAndSet(null, termination)) {
                termination.doTask();
                this.spdyStream.onInputClosed();
            }
        }
    }

    private void sendWindowUpdate(Buffer data) {
        this.sendWindowUpdate(data != null ? data.remaining() : 0, false);
    }

    private void sendWindowUpdate(int delta, boolean isForce) {
        this.spdySession.sendWindowUpdate(delta);
        int currentUnackedBytes = this.unackedReadBytes.addAndGet(delta);
        int windowSize = this.spdyStream.getLocalWindowSize();
        if (currentUnackedBytes > 0 && (currentUnackedBytes > windowSize / 2 || isForce) && this.unackedReadBytes.compareAndSet(currentUnackedBytes, 0)) {
            this.spdyStream.outputSink.writeWindowUpdate(currentUnackedBytes);
        }
    }

    private boolean checkContentLength(int newDataChunkSize) {
        if (this.remainingContentLength == Long.MIN_VALUE) {
            this.remainingContentLength = this.spdyStream.getInputHttpHeader().getContentLength();
        }
        if (this.remainingContentLength >= 0L) {
            this.remainingContentLength -= (long)newDataChunkSize;
            if (this.remainingContentLength == 0L) {
                return true;
            }
            if (this.remainingContentLength < 0L) {
                throw new IllegalStateException("SpdyStream #" + this.spdyStream.getStreamId() + ": peer is sending data beyound specified content-length limit");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchOffExpectInput() {
        Object object = this.expectInputSwitchSync;
        synchronized (object) {
            if (this.expectInputSwitch) {
                this.expectInputSwitch = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int switchOffExpectInputIfQueueNotEmpty() {
        Object object = this.expectInputSwitchSync;
        synchronized (object) {
            int queueSize;
            if (this.expectInputSwitch && (queueSize = this.inputQueueSize.get()) > 0) {
                this.expectInputSwitch = false;
                return queueSize;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchOnExpectInput() {
        Object object = this.expectInputSwitchSync;
        synchronized (object) {
            this.expectInputSwitch = true;
        }
    }

    private HttpContent buildHttpContent(Buffer payload) {
        HttpContent httpContent;
        boolean isFin;
        SpdyStream.Termination localTermination = this.closeFlag.get();
        boolean bl = isFin = localTermination == Constants.IN_FIN_TERMINATION;
        if (payload.hasRemaining() || localTermination == null || isFin) {
            HttpHeader inputHttpHeader = this.spdyStream.getInputHttpHeader();
            inputHttpHeader.setExpectContent(!isFin);
            httpContent = HttpContent.builder((HttpHeader)inputHttpHeader).content(payload).last(isFin).build();
        } else {
            httpContent = this.buildBrokenHttpContent(new EOFException(localTermination.getDescription()));
        }
        return httpContent;
    }

    private HttpContent buildBrokenHttpContent(Throwable t) {
        this.spdyStream.getInputHttpHeader().setExpectContent(false);
        return HttpBrokenContent.builder((HttpHeader)this.spdyStream.getInputHttpHeader()).error(t).build();
    }

    private static final class InputElement {
        private final Object content;
        private final boolean isLast;
        private final boolean isService;

        public InputElement(Object content, boolean isLast, boolean isService) {
            this.content = content;
            this.isLast = isLast;
            this.isService = isService;
        }

        private Buffer toBuffer() {
            return !this.isService ? (Buffer)this.content : Buffers.EMPTY_BUFFER;
        }
    }
}

