/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;

public class SpdyHeader
implements Cacheable {
    private static final ThreadCache.CachedTypeIndex<SpdyHeader> CACHE_IDX = ThreadCache.obtainIndex(SpdyHeader.class, (int)8);
    protected Buffer buffer;
    protected int flags;
    protected int length;
    protected boolean control;
    protected int version = -1;
    protected int type = -1;
    protected int streamId = -1;

    private SpdyHeader() {
    }

    private void initialize(Buffer buffer) {
        this.buffer = buffer;
        long header = buffer.getLong();
        int first32 = (int)(header >>> 32);
        int second32 = (int)(header & 0xFFFFFFFFL);
        this.flags = second32 >>> 24;
        this.length = second32 & 0xFFFFFF;
        boolean bl = this.control = (first32 & Integer.MIN_VALUE) != 0;
        if (this.control) {
            this.version = first32 >>> 16 & Short.MAX_VALUE;
            this.type = first32 & 0xFFFF;
        } else {
            this.streamId = first32 & Integer.MAX_VALUE;
        }
    }

    public static SpdyHeader wrap(Buffer buffer) {
        SpdyHeader header = (SpdyHeader)ThreadCache.takeFromCache(CACHE_IDX);
        if (header == null) {
            header = new SpdyHeader();
        }
        header.initialize(buffer);
        return header;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isControl() {
        return this.control;
    }

    public int getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public Buffer getUnderlying() {
        return this.buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SpdyFrameHeader");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", version=").append(this.version);
        sb.append(", type=").append(this.type);
        sb.append(", flags=").append(this.flags);
        sb.append(", control=").append(this.control);
        sb.append(", length=").append(this.length);
        sb.append('}');
        return sb.toString();
    }

    public void recycle() {
        this.buffer = null;
        this.version = -1;
        this.type = -1;
        this.flags = 0;
        this.length = 0;
        this.streamId = -1;
        this.control = false;
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }
}

