/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.SpdyStreamException;

public abstract class Source {
    public abstract long remaining();

    public abstract Buffer read(int var1) throws SpdyStreamException;

    public abstract boolean hasRemaining();

    public abstract void release();

    public static SourceFactory factory(SpdyStream spdyStream) {
        return new SourceFactory(spdyStream);
    }

    public static final class SourceFactory {
        private final SpdyStream spdyStream;

        private SourceFactory(SpdyStream spdyStream) {
            this.spdyStream = spdyStream;
        }

        public Source createByteArraySource(byte[] array) {
            return this.createByteArraySource(array, 0, array.length);
        }

        public Source createByteArraySource(byte[] array, int offs, int len) {
            return new ByteArraySource(array, offs, len, this.spdyStream);
        }

        public Source createBufferSource(Buffer buffer) {
            return new BufferSource(buffer, this.spdyStream);
        }

        public Source createFileSource(String filename) throws FileNotFoundException, IOException {
            return this.createFileSource(new File(filename));
        }

        public Source createFileSource(File file) throws FileNotFoundException, IOException {
            if (!file.exists()) {
                throw new IOException("File does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("File is not identified as a normal file. Is it a directory?");
            }
            return new FileSource(file, this.spdyStream);
        }

        public Source createStringSource(String string) {
            return this.createStringSource(string, Constants.DEFAULT_HTTP_CHARSET);
        }

        public Source createStringSource(String string, Charset charset) {
            return new BufferSource(Buffers.wrap((MemoryManager)this.spdyStream.getSpdySession().getMemoryManager(), (String)string, (Charset)charset), this.spdyStream);
        }
    }

    private static class ByteArraySource
    extends Source {
        private boolean isClosed;
        private final byte[] array;
        private int offs;
        private int remaining;
        private final SpdyStream spdyStream;

        protected ByteArraySource(byte[] array, int offs, int len, SpdyStream spdyStream) {
            this.array = array;
            this.offs = offs;
            this.remaining = len;
            this.spdyStream = spdyStream;
        }

        @Override
        public long remaining() {
            return this.remaining;
        }

        @Override
        public Buffer read(int length) throws SpdyStreamException {
            if (this.isClosed) {
                throw new SpdyStreamException(this.spdyStream.getStreamId(), 6, "The source was closed");
            }
            if (length == 0 || this.remaining == 0) {
                return Buffers.EMPTY_BUFFER;
            }
            int bytesToReturn = Math.min(this.remaining, length);
            Buffer buffer = Buffers.wrap((MemoryManager)this.spdyStream.getSpdySession().getMemoryManager(), (byte[])this.array, (int)this.offs, (int)bytesToReturn);
            this.offs += bytesToReturn;
            this.remaining -= bytesToReturn;
            return buffer;
        }

        @Override
        public boolean hasRemaining() {
            return !this.isClosed && this.remaining > 0;
        }

        @Override
        public void release() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }
    }

    private static class BufferSource
    extends Source {
        private boolean isClosed;
        private Buffer buffer;
        private final SpdyStream spdyStream;

        protected BufferSource(Buffer buffer, SpdyStream spdyStream) {
            this.buffer = buffer;
            this.spdyStream = spdyStream;
        }

        @Override
        public long remaining() {
            return this.buffer.remaining();
        }

        @Override
        public Buffer read(int length) throws SpdyStreamException {
            if (this.isClosed) {
                throw new SpdyStreamException(this.spdyStream.getStreamId(), 6, "The source was closed");
            }
            int remaining = this.buffer.remaining();
            if (length == 0 || remaining == 0) {
                return Buffers.EMPTY_BUFFER;
            }
            int bytesToSplit = Math.min(remaining, length);
            Buffer newBuf = this.buffer.split(this.buffer.position() + bytesToSplit);
            Buffer bufferToReturn = this.buffer;
            this.buffer = newBuf;
            return bufferToReturn;
        }

        @Override
        public boolean hasRemaining() {
            return !this.isClosed && this.buffer.hasRemaining();
        }

        @Override
        public void release() {
            if (!this.isClosed) {
                this.isClosed = true;
                this.buffer.tryDispose();
            }
        }
    }

    private static class FileSource
    extends Source {
        private boolean isClosed;
        private final FileInputStream fis;
        private final FileChannel fileChannel;
        private final SpdyStream spdyStream;
        private long fileLengthRemaining;

        protected FileSource(File file, SpdyStream spdyStream) throws FileNotFoundException {
            this.fileLengthRemaining = file.length();
            this.fis = new FileInputStream(file);
            this.fileChannel = this.fis.getChannel();
            this.spdyStream = spdyStream;
        }

        @Override
        public long remaining() {
            return this.fileLengthRemaining;
        }

        @Override
        public Buffer read(int length) throws SpdyStreamException {
            int bytesRead;
            if (this.isClosed) {
                throw new SpdyStreamException(this.spdyStream.getStreamId(), 6, "The source was closed");
            }
            if (this.fileLengthRemaining == 0L) {
                return Buffers.EMPTY_BUFFER;
            }
            Buffer buffer = this.spdyStream.getSpdySession().getMemoryManager().allocate(length);
            try {
                bytesRead = (int)Buffers.readFromFileChannel((FileChannel)this.fileChannel, (Buffer)buffer);
            }
            catch (IOException e) {
                throw new SpdyStreamException(this.spdyStream.getStreamId(), 6, e);
            }
            if (bytesRead == -1) {
                throw new SpdyStreamException(this.spdyStream.getStreamId(), 6, "Unexpected end of file");
            }
            this.fileLengthRemaining -= (long)bytesRead;
            buffer.trim();
            return buffer;
        }

        @Override
        public boolean hasRemaining() {
            return !this.isClosed && this.fileLengthRemaining > 0L;
        }

        @Override
        public void release() {
            if (!this.isClosed) {
                this.isClosed = true;
                try {
                    this.fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

