/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.SpdySessionException;
import org.glassfish.grizzly.spdy.frames.GoAwayFrame;
import org.glassfish.grizzly.spdy.frames.OversizedFrame;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;
import org.glassfish.grizzly.utils.NullaryFunction;
import org.slf4j.Logger;

public class SpdyFramingFilter
extends BaseFilter {
    private static final int DEFAULT_MAX_FRAME_LENGTH = 0x1000000;
    private static final Logger LOGGER = Grizzly.logger(SpdyFramingFilter.class);
    static final int HEADER_LEN = 8;
    private static final Attribute<FrameParsingState> frameParsingState = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SpdyFramingFilter.class.getName() + ".frameParsingState", (NullaryFunction)new NullaryFunction<FrameParsingState>(){

        public FrameParsingState evaluate() {
            return new FrameParsingState();
        }
    });
    private volatile int maxFrameLength = 0x1000000;

    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public void setMaxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        final Connection connection = ctx.getConnection();
        FrameParsingState parsingState = (FrameParsingState)frameParsingState.get((AttributeStorage)connection);
        Buffer message = (Buffer)ctx.getMessage();
        if (parsingState.bytesToSkip > 0 && !this.skip(parsingState, message)) {
            return ctx.getStopAction();
        }
        try {
            ParsingResult parsingResult = this.parseFrame(ctx, parsingState, message);
            SpdyFrame frame = parsingResult.frame();
            Buffer remainder = parsingResult.remainder();
            if (frame == null) {
                return ctx.getStopAction((Object)remainder);
            }
            boolean logit = LOGGER.isDebugEnabled();
            if (logit) {
                LOGGER.debug("Rx [1]: connection={}, frame={}", (Object)connection, (Object)frame);
            }
            if (frame.isService()) {
                ctx.setMessage((Object)frame);
                return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null);
            }
            if (!remainder.hasRemaining()) {
                ctx.setMessage((Object)frame);
                return ctx.getInvokeAction();
            }
            List<SpdyFrame> frameList = parsingState.getList();
            frameList.add(frame);
            while (remainder.remaining() >= 8) {
                parsingResult = this.parseFrame(ctx, parsingState, remainder);
                frame = parsingResult.frame();
                remainder = parsingResult.remainder();
                if (frame == null) break;
                if (logit) {
                    LOGGER.debug("Rx [2]: connection={}, frame={}", (Object)connection, (Object)frame);
                }
                frameList.add(frame);
                if (!frame.isService()) continue;
                ctx.setMessage(frameList.size() > 1 ? frameList : frameList.remove(0));
                return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null);
            }
            ctx.setMessage(frameList.size() > 1 ? frameList : frameList.remove(0));
            return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null, null);
        }
        catch (SpdySessionException e) {
            SpdySessionException error = e;
            GoAwayFrame goAwayFrame = GoAwayFrame.builder().statusCode(error.getGoAwayStatus()).build();
            Buffer sndBuffer = goAwayFrame.toBuffer(ctx.getMemoryManager());
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.write((Object)sndBuffer, (CompletionHandler)new EmptyCompletionHandler<WriteResult>(){

                public void completed(WriteResult result) {
                    connection.closeSilently();
                    ctx.completeAndRecycle();
                }
            });
            return suspendAction;
        }
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Tx: connection={}, frame={}", (Object)ctx.getConnection(), message);
        }
        MemoryManager memoryManager = ctx.getMemoryManager();
        if (message instanceof SpdyFrame) {
            SpdyFrame frame = (SpdyFrame)message;
            ctx.setMessage((Object)frame.toBuffer(memoryManager));
            frame.recycle();
        } else if (message instanceof List) {
            Buffer resultBuffer = null;
            List frames = (List)message;
            int framesCount = frames.size();
            for (int i = 0; i < framesCount; ++i) {
                SpdyFrame frame = (SpdyFrame)frames.get(i);
                Buffer buffer = frame.toBuffer(memoryManager);
                frame.recycle();
                resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, resultBuffer, (Buffer)buffer);
            }
            frames.clear();
            ctx.setMessage(resultBuffer);
        }
        return ctx.getInvokeAction();
    }

    private ParsingResult parseFrame(FilterChainContext ctx, FrameParsingState state, Buffer buffer) throws SpdySessionException {
        int bufferSize = buffer.remaining();
        if (bufferSize < 8) {
            return state.parsingResult.reset(null, buffer);
        }
        int bufferPos = buffer.position();
        int len = SpdyFramingFilter.getMessageLength(buffer, bufferPos);
        if (!this.checkFrameLength(len)) {
            Buffer remainder;
            SpdyFrame overSizedFrame = this.createOversizedFrame(ctx, buffer);
            int remaining = buffer.remaining();
            if (remaining > len) {
                remainder = buffer.split(bufferPos + len);
            } else {
                remainder = Buffers.EMPTY_BUFFER;
                state.bytesToSkip = len - remaining;
            }
            return state.parsingResult.reset(overSizedFrame, remainder);
        }
        int totalLen = len + 8;
        if (buffer.remaining() < totalLen) {
            return state.parsingResult.reset(null, buffer);
        }
        Buffer remainder = buffer.split(bufferPos + totalLen);
        SpdyFrame frame = SpdyFrame.wrap(buffer);
        return state.parsingResult.reset(frame, remainder);
    }

    private static int getMessageLength(Buffer message, int position) {
        return ((message.get(position + 5) & 0xFF) << 16) + ((message.get(position + 6) & 0xFF) << 8) + (message.get(position + 7) & 0xFF);
    }

    private boolean checkFrameLength(int frameLen) {
        return frameLen <= this.maxFrameLength;
    }

    private boolean skip(FrameParsingState parsingState, Buffer message) {
        int dec = Math.min(parsingState.bytesToSkip, message.remaining());
        parsingState.bytesToSkip -= dec;
        message.position(message.position() + dec);
        if (message.hasRemaining()) {
            message.shrink();
            return true;
        }
        message.tryDispose();
        return false;
    }

    private SpdyFrame createOversizedFrame(FilterChainContext ctx, Buffer message) {
        SpdyHeader spdyHeader = SpdyHeader.wrap(message);
        OversizedFrame oversizedFrame = OversizedFrame.create(spdyHeader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Rx: oversized frame! connection={}, header={}", (Object)ctx.getConnection(), (Object)spdyHeader);
        }
        return oversizedFrame;
    }

    private static final class FrameParsingState {
        private List<SpdyFrame> spdyFrameList;
        private int bytesToSkip;
        private final ParsingResult parsingResult = new ParsingResult();

        private FrameParsingState() {
        }

        List<SpdyFrame> getList() {
            if (this.spdyFrameList == null) {
                this.spdyFrameList = new ArrayList<SpdyFrame>(4);
            }
            return this.spdyFrameList;
        }
    }

    private static final class ParsingResult {
        private SpdyFrame frame;
        private Buffer remainder;

        private ParsingResult() {
        }

        private ParsingResult reset(SpdyFrame frame, Buffer remainder) {
            this.frame = frame;
            this.remainder = remainder;
            return this;
        }

        private SpdyFrame frame() {
            return this.frame;
        }

        private Buffer remainder() {
            return this.remainder;
        }
    }
}

