/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.sni;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.sni.SNIClientConfigResolver;
import org.glassfish.grizzly.sni.SNIConfig;
import org.glassfish.grizzly.sni.SNIFilter;
import org.glassfish.grizzly.sni.SNIServerConfigResolver;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.utils.FreePortFinder;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.JdkVersion;
import org.glassfish.grizzly.utils.StringFilter;
import org.junit.Assert;
import org.junit.Test;

public class SNITest {
    public final int PORT = FreePortFinder.findFreePort();
    private static final boolean JDK7_OR_HIGHER = JdkVersion.getJdkVersion().compareTo(JdkVersion.parseVersion((String)"1.7")) >= 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientServerSNI() throws Exception {
        String sniHostValue = "sni-test.com";
        String msg = "Hello world!";
        final Attribute sniHostAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("sni-host-attr");
        if (!JDK7_OR_HIGHER) {
            return;
        }
        final SSLEngineConfigurator sslServerEngineConfig = new SSLEngineConfigurator(SNITest.createSSLContextConfigurator().createSSLContext(), false, false, false);
        final SSLEngineConfigurator sslClientEngineConfig = new SSLEngineConfigurator(SNITest.createSSLContextConfigurator().createSSLContext(), true, false, false);
        SNIFilter sniFilter = new SNIFilter();
        sniFilter.setServerSSLConfigResolver(new SNIServerConfigResolver(){

            public SNIConfig resolve(Connection connection, String hostname) {
                sniHostAttr.set((AttributeStorage)connection, (Object)hostname);
                return SNIConfig.newServerConfig((SSLEngineConfigurator)sslServerEngineConfig);
            }
        });
        sniFilter.setClientSSLConfigResolver(new SNIClientConfigResolver(){

            public SNIConfig resolve(Connection connection) {
                return SNIConfig.newClientConfig((String)"sni-test.com", (SSLEngineConfigurator)sslClientEngineConfig);
            }
        });
        final FutureImpl resultFuture = Futures.createSafeFuture();
        FilterChain chain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)sniFilter).add((Filter)new StringFilter()).add((Filter)new BaseFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                String msg = (String)ctx.getMessage();
                String sniHost = (String)sniHostAttr.get((AttributeStorage)ctx.getConnection());
                resultFuture.result((Object)new String[]{msg, sniHost});
                return ctx.getInvokeAction();
            }
        }).build();
        TCPNIOTransport transport = ((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setProcessor((Processor)chain)).build();
        try {
            transport.bind(this.PORT);
            transport.start();
            Connection c = (Connection)transport.connect("localhost", this.PORT).get();
            c.write((Object)"Hello world!");
            String[] result = (String[])resultFuture.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)"Hello world!", (Object)result[0]);
            Assert.assertEquals((Object)"sni-test.com", (Object)result[1]);
        }
        finally {
            transport.shutdownNow();
        }
    }

    private static SSLContextConfigurator createSSLContextConfigurator() {
        URL keystoreUrl;
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        ClassLoader cl = SNITest.class.getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        if (cacertsUrl != null) {
            sslContextConfigurator.setTrustStoreFile(cacertsUrl.getFile());
            sslContextConfigurator.setTrustStorePass("changeit");
        }
        if ((keystoreUrl = cl.getResource("ssltest-keystore.jks")) != null) {
            sslContextConfigurator.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfigurator.setKeyStorePass("changeit");
        }
        return sslContextConfigurator;
    }
}

