/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.istack.tools.DefaultAuthenticator;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class OptionsJUTest
extends TestCase {
    private Options o;

    public OptionsJUTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.o = new Options();
        this.o.targetDir = new File(System.getProperty("java.io.tmpdir"), "jxc_optionsTest");
        this.o.targetDir.mkdirs();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        OptionsJUTest.delDirs(this.o.targetDir);
    }

    public void testCreateCodeWriter() throws JClassAlreadyExistsException, IOException {
        JCodeModel jcm = new JCodeModel();
        JDefinedClass c = jcm._class("test.TestClass");
        c.constructor(1);
        this.o.readOnly = false;
        this.o.encoding = "UTF-8";
        jcm.build(this.o.createCodeWriter());
        File cls = new File(this.o.targetDir, "test/TestClass.java");
        FileInputStream fis = new FileInputStream(cls);
        byte[] in = new byte[13];
        fis.read(in);
        fis.close();
        cls.delete();
        String inStr = new String(in, "UTF-8");
        OptionsJUTest.assertTrue((String)("Got: '" + inStr + "'"), (boolean)inStr.contains("// This f"));
        this.o.noFileHeader = true;
        this.o.encoding = "UTF-16";
        jcm.build(this.o.createCodeWriter());
        cls = new File(this.o.targetDir, "test/TestClass.java");
        fis = new FileInputStream(cls);
        in = new byte[26];
        fis.read(in);
        fis.close();
        cls.delete();
        inStr = new String(in, "UTF-16");
        OptionsJUTest.assertTrue((String)("Got: '" + inStr + "'"), (boolean)inStr.contains("package t"));
        this.o.noFileHeader = false;
        this.o.encoding = null;
        jcm.build(this.o.createCodeWriter());
        cls = new File(this.o.targetDir, "test/TestClass.java");
        fis = new FileInputStream(cls);
        in = new byte[84];
        fis.read(in);
        fis.close();
        cls.delete();
        inStr = new String(in, Charset.defaultCharset().name());
        OptionsJUTest.assertTrue((String)("Got: '" + inStr + "'"), (boolean)inStr.contains("// This f"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxySettings() throws Exception {
        Options opts = new Options();
        File grammar = File.createTempFile("jaxbproxytest", "xsd");
        grammar.deleteOnExit();
        try {
            opts.parseArguments(new String[]{"-httpproxy", "www.proxy", grammar.getAbsolutePath()});
            OptionsJUTest.assertEquals((String)"www.proxy", (String)this.getField("proxyHost", opts));
            OptionsJUTest.assertEquals((String)"80", (String)this.getField("proxyPort", opts));
            OptionsJUTest.assertNull((Object)opts.proxyAuth);
        }
        catch (BadCommandLineException ex) {
            Logger.getLogger(OptionsJUTest.class.getName()).log(Level.SEVERE, null, ex);
            OptionsJUTest.fail();
        }
        finally {
            if (opts.proxyAuth != null) {
                DefaultAuthenticator.reset();
            }
        }
        opts = new Options();
        try {
            opts.parseArguments(new String[]{"-httpproxy", "www.proxy1:4321", grammar.getAbsolutePath()});
            OptionsJUTest.assertEquals((String)"www.proxy1", (String)this.getField("proxyHost", opts));
            OptionsJUTest.assertEquals((String)"4321", (String)this.getField("proxyPort", opts));
            OptionsJUTest.assertNull((Object)opts.proxyAuth);
        }
        catch (BadCommandLineException ex) {
            Logger.getLogger(OptionsJUTest.class.getName()).log(Level.SEVERE, null, ex);
            OptionsJUTest.fail();
        }
        finally {
            if (opts.proxyAuth != null) {
                DefaultAuthenticator.reset();
            }
        }
        opts = new Options();
        try {
            opts.parseArguments(new String[]{"-httpproxy", "user:pwd@www.proxy3:7890", grammar.getAbsolutePath()});
            OptionsJUTest.assertEquals((String)"www.proxy3", (String)this.getField("proxyHost", opts));
            OptionsJUTest.assertEquals((String)"7890", (String)this.getField("proxyPort", opts));
            OptionsJUTest.assertEquals((String)"user:pwd", (String)opts.proxyAuth);
        }
        catch (BadCommandLineException ex) {
            Logger.getLogger(OptionsJUTest.class.getName()).log(Level.SEVERE, null, ex);
            OptionsJUTest.fail();
        }
        finally {
            if (opts.proxyAuth != null) {
                DefaultAuthenticator.reset();
            }
        }
        opts = new Options();
        try {
            opts.parseArguments(new String[]{"-httpproxy", "duke:s@cr@t@proxy98", grammar.getAbsolutePath()});
            OptionsJUTest.assertEquals((String)"proxy98", (String)this.getField("proxyHost", opts));
            OptionsJUTest.assertEquals((String)"80", (String)this.getField("proxyPort", opts));
            OptionsJUTest.assertEquals((String)"duke:s@cr@t", (String)opts.proxyAuth);
        }
        catch (BadCommandLineException ex) {
            Logger.getLogger(OptionsJUTest.class.getName()).log(Level.SEVERE, null, ex);
            OptionsJUTest.fail();
        }
        finally {
            if (opts.proxyAuth != null) {
                DefaultAuthenticator.reset();
            }
        }
    }

    public static void delDirs(File ... dirs) {
        for (File dir : dirs) {
            if (!dir.exists()) continue;
            if (dir.isDirectory()) {
                for (File f : dir.listFiles()) {
                    OptionsJUTest.delDirs(f);
                }
                dir.delete();
                continue;
            }
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getField(String fieldName, Object instance) {
        Field f = null;
        boolean reset = false;
        try {
            f = Options.class.getDeclaredField(fieldName);
            if (!f.isAccessible()) {
                reset = true;
                f.setAccessible(true);
            }
            String string = (String)f.get(instance);
            return string;
        }
        catch (Exception ex) {
            Logger.getLogger(OptionsJUTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (reset && f != null) {
                f.setAccessible(false);
            }
        }
        return null;
    }
}

