/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.api;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.SingleStreamCodeWriter;
import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.Property;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import com.sun.xml.bind.v2.util.XmlFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.opts.BooleanOption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Driver {
    public BooleanOption stax = new BooleanOption("-stax");
    public BooleanOption code = new BooleanOption("-code");
    private File[] files;

    private Driver(String[] args) throws CmdLineException {
        CmdLineParser p = new CmdLineParser();
        p.addOptionClass((Object)this);
        p.parse(args);
        List files = p.getArguments();
        this.files = new File[files.size()];
        int i = 0;
        for (String f : files) {
            this.files[i++] = new File(f);
        }
    }

    public static void main(String[] args) throws Exception {
        new Driver(args).run();
    }

    private void run() throws Exception {
        SchemaCompiler compiler = XJC.createSchemaCompiler();
        ErrorReceiverImpl er = new ErrorReceiverImpl();
        compiler.setErrorListener((ErrorListener)er);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        for (File value : this.files) {
            String url = value.toURL().toString();
            if (value.getName().toLowerCase().endsWith(".wsdl")) {
                DocumentBuilderFactory dbf = XmlFactory.createDocumentBuilderFactory((boolean)false);
                Document dom = dbf.newDocumentBuilder().parse(value);
                compiler.parseSchema(url, this.findSchemas(dom.getDocumentElement()));
                continue;
            }
            if (this.stax.isOn()) {
                XMLStreamReader r = xif.createXMLStreamReader(new FileInputStream(value));
                if (r.getEventType() != 7) {
                    r.next();
                }
                System.err.println("parsing " + value);
                compiler.parseSchema(url, r);
                continue;
            }
            compiler.parseSchema(new InputSource(url));
        }
        S2JJAXBModel model = compiler.bind();
        if (model == null) {
            System.out.println("failed to compile.");
            return;
        }
        Driver.dumpModel(model);
        JCodeModel cm = model.generateCode(null, (ErrorListener)er);
        if (this.code.isOn()) {
            cm.build((CodeWriter)new SingleStreamCodeWriter((OutputStream)System.out));
        }
    }

    private Element findSchemas(Element e) {
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            Element x = (Element)n;
            if (x.getLocalName().equals("schema") && x.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                return x;
            }
            if ((x = this.findSchemas(x)) == null) continue;
            return x;
        }
        return null;
    }

    public static void dumpModel(S2JJAXBModel model) {
        System.out.println("--- class list ---");
        for (String s : model.getClassList()) {
            System.out.println("  " + s);
        }
        System.out.println();
        for (Mapping m : model.getMappings()) {
            System.out.println(m.getElement() + "<->" + m.getType());
            List detail = m.getWrapperStyleDrilldown();
            if (detail == null) {
                System.out.println("(not a wrapper-style element)");
            } else {
                for (Property p : detail) {
                    System.out.println("  " + p.name() + '\t' + p.type() + '\t' + p.elementName());
                }
            }
            System.out.println();
        }
    }

    private static class ErrorReceiverImpl
    extends ConsoleErrorReporter
    implements ErrorListener {
        private ErrorReceiverImpl() {
        }
    }
}

