/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.tools.xjc.OptionsJUTest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.TestCase;

public abstract class XjcAntTaskTestBase
extends TestCase {
    protected File projectDir;
    protected File srcDir;
    protected File buildDir;
    protected File script;
    protected boolean tryDelete = false;

    public abstract String getBuildScript();

    protected void setUp() throws Exception {
        super.setUp();
        this.projectDir = new File(System.getProperty("java.io.tmpdir"), ((Object)((Object)this)).getClass().getSimpleName() + "-" + this.getName());
        if (this.projectDir.exists() && this.projectDir.isDirectory()) {
            OptionsJUTest.delDirs(this.projectDir);
        }
        this.srcDir = new File(this.projectDir, "src");
        this.buildDir = new File(this.projectDir, "build");
        XjcAntTaskTestBase.assertTrue((String)"project dir created", (boolean)this.projectDir.mkdirs());
        this.script = XjcAntTaskTestBase.copy(this.projectDir, this.getBuildScript(), XjcAntTaskTestBase.class.getResourceAsStream("resources/" + this.getBuildScript()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.tryDelete) {
            OptionsJUTest.delDirs(this.srcDir, this.buildDir);
            this.script.delete();
            XjcAntTaskTestBase.assertTrue((String)"project dir exists", (boolean)this.projectDir.delete());
        }
    }

    protected static File copy(File dest, String name, InputStream is) throws FileNotFoundException, IOException {
        return XjcAntTaskTestBase.copy(dest, name, is, null);
    }

    protected static File copy(File dest, String name, InputStream is, String targetEncoding) throws FileNotFoundException, IOException {
        File destFile = new File(dest, name);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFile));
        OutputStreamWriter w = targetEncoding != null ? new OutputStreamWriter((OutputStream)os, targetEncoding) : new OutputStreamWriter(os);
        byte[] b = new byte[4096];
        int len = -1;
        while ((len = is.read(b)) > 0) {
            ((Writer)w).write(new String(b), 0, len);
        }
        ((Writer)w).flush();
        ((Writer)w).close();
        is.close();
        return destFile;
    }

    static boolean is9() {
        return System.getProperty("java.version").startsWith("9");
    }
}

