/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.codemodel.JJavaName;
import java.util.ArrayList;

public class NameUtil {
    protected static boolean isPunct(char c) {
        return c == '-' || c == '.' || c == ':' || c == '_' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    protected static boolean isDigit(char c) {
        return c >= '0' && c <= '9' || Character.isDigit(c);
    }

    protected static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z' || Character.isUpperCase(c);
    }

    protected static boolean isLower(char c) {
        return c >= 'a' && c <= 'z' || Character.isLowerCase(c);
    }

    protected static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    public static String capitalize(String s) {
        if (!NameUtil.isLower(s.charAt(0))) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        sb.append(Character.toUpperCase(s.charAt(0)));
        sb.append(s.substring(1).toLowerCase());
        return sb.toString();
    }

    protected static int nextBreak(String s, int start) {
        int n = s.length();
        for (int i = start; i < n; ++i) {
            char c0 = s.charAt(i);
            if (i >= n - 1) continue;
            char c1 = s.charAt(i + 1);
            if (NameUtil.isPunct(c1)) {
                return i + 1;
            }
            if (NameUtil.isDigit(c0) && !NameUtil.isDigit(c1)) {
                return i + 1;
            }
            if (!NameUtil.isDigit(c0) && NameUtil.isDigit(c1)) {
                return i + 1;
            }
            if (NameUtil.isLower(c0) && !NameUtil.isLower(c1)) {
                return i + 1;
            }
            if (NameUtil.isLetter(c0) && !NameUtil.isLetter(c1)) {
                return i + 1;
            }
            if (!NameUtil.isLetter(c0) && NameUtil.isLetter(c1)) {
                return i + 1;
            }
            if (i >= n - 2) continue;
            char c2 = s.charAt(i + 2);
            if (!NameUtil.isUpper(c0) || !NameUtil.isUpper(c1) || !NameUtil.isLower(c2)) continue;
            return i + 1;
        }
        return -1;
    }

    public static String[] toWordList(String s) {
        ArrayList<String> ss = new ArrayList<String>();
        int n = s.length();
        int i = 0;
        while (i < n) {
            while (i < n && NameUtil.isPunct(s.charAt(i))) {
                ++i;
            }
            if (i >= n) break;
            int b = NameUtil.nextBreak(s, i);
            String w = b == -1 ? s.substring(i) : s.substring(i, b);
            ss.add(NameUtil.escape(NameUtil.capitalize(w)));
            if (b == -1) break;
            i = b;
        }
        return ss.toArray(new String[0]);
    }

    protected static String toMixedCaseName(String[] ss, boolean startUpper) {
        StringBuffer sb = new StringBuffer();
        if (ss.length > 0) {
            sb.append(startUpper ? ss[0] : ss[0].toLowerCase());
            for (int i = 1; i < ss.length; ++i) {
                sb.append(ss[i]);
            }
        }
        return sb.toString();
    }

    protected static String toMixedCaseVariableName(String[] ss, boolean startUpper, boolean cdrUpper) {
        if (cdrUpper) {
            for (int i = 1; i < ss.length; ++i) {
                ss[i] = NameUtil.capitalize(ss[i]);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (ss.length > 0) {
            sb.append(startUpper ? ss[0] : ss[0].toLowerCase());
            for (int i = 1; i < ss.length; ++i) {
                sb.append(ss[i]);
            }
        }
        return sb.toString();
    }

    public static String toConstantName(String s) {
        return NameUtil.toConstantName(NameUtil.toWordList(s));
    }

    public static String toConstantName(String[] ss) {
        StringBuffer sb = new StringBuffer();
        if (ss.length > 0) {
            sb.append(ss[0].toUpperCase());
            for (int i = 1; i < ss.length; ++i) {
                sb.append('_');
                sb.append(ss[i].toUpperCase());
            }
        }
        return sb.toString();
    }

    public static void escape(StringBuffer sb, String s, int start) {
        int n = s.length();
        for (int i = start; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append("_");
            if (c <= '\u000f') {
                sb.append("000");
            } else if (c <= '\u00ff') {
                sb.append("00");
            } else if (c <= '\u0fff') {
                sb.append("0");
            }
            sb.append(Integer.toString(c, 16));
        }
    }

    private static String escape(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            StringBuffer sb = new StringBuffer(s.substring(0, i));
            NameUtil.escape(sb, s, i);
            return sb.toString();
        }
        return s;
    }

    public static String escapeURI(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isSpaceChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getParentUriPath(String uriPath) {
        int idx = uriPath.lastIndexOf(47);
        if (uriPath.endsWith("/")) {
            uriPath = uriPath.substring(0, idx);
            idx = uriPath.lastIndexOf(47);
        }
        return uriPath.substring(0, idx) + "/";
    }

    public static String normalizeUriPath(String uriPath) {
        if (uriPath.endsWith("/")) {
            return uriPath;
        }
        int idx = uriPath.lastIndexOf(47);
        return uriPath.substring(0, idx + 1);
    }

    public static boolean equalsIgnoreCase(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            return s.equalsIgnoreCase(t);
        }
        return false;
    }

    public static boolean equal(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            return s.equals(t);
        }
        return false;
    }

    public static String toClassName(String s) {
        return NameUtil.toMixedCaseName(NameUtil.toWordList(s), true);
    }

    public static String toVariableName(String s) {
        return NameUtil.toMixedCaseName(NameUtil.toWordList(s), false);
    }

    public static String toMethodName(String s) {
        String m = NameUtil.toMixedCaseName(NameUtil.toWordList(s), false);
        if (JJavaName.isJavaIdentifier((String)m)) {
            return m;
        }
        return '_' + m;
    }

    public static String toInterfaceName(String token) {
        return NameUtil.toClassName(token);
    }

    public static String toPropertyName(String s) {
        return NameUtil.toClassName(s);
    }

    public static String toPackageName(String s) {
        return NameUtil.toMixedCaseName(NameUtil.toWordList(s), false);
    }
}

