/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.flickr;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.commons.io.IOUtils;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.ParamFactory;
import org.mule.util.StringUtils;

public class FlickrSignatureFactory
implements ParamFactory {
    public Object create(String paramName, boolean optional, InvocationContext invocationContext) {
        String secretKey = (String)invocationContext.getIBeanConfig().getPropertyParams().get("secret_key");
        if (secretKey == null) {
            throw new IllegalArgumentException("A Flickr secret key must be set using one of the init methods on this iBeans");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(secretKey);
        try {
            if ("GET".equals(invocationContext.getIBeanConfig().getPropertyParams().get("http.method")) || invocationContext.isTemplateMethod()) {
                Map params = invocationContext.isTemplateMethod() ? invocationContext.getTemplateSpecificUriParams() : invocationContext.getCallSpecificUriParams();
                for (Map.Entry entry : params.entrySet()) {
                    if (((String)entry.getKey()).equals(paramName) || ((String)entry.getKey()).equals("photo")) continue;
                    buf.append((String)entry.getKey()).append((String)entry.getValue());
                }
            } else {
                for (DataSource ds : invocationContext.getIBeanConfig().getAttachments()) {
                    if (ds.getName().equals("photo") || ds.getName().equals("api_sig")) continue;
                    buf.append(ds.getName()).append(IOUtils.toCharArray((InputStream)ds.getInputStream()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String sig = buf.toString();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(buf.toString().getBytes("UTF-8"));
            sig = StringUtils.toHexString((byte[])bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sig;
    }
}

