/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.flickr;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.mule.api.annotations.Transformer;
import org.mule.ibeans.IBeansSupport;
import org.mule.ibeans.flickr.model.AuthToken;
import org.mule.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class FlickrTransformers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transformer
    public BufferedImage streamToBufferedImage(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)is, (OutputStream)baos);
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            if (image == null) {
                throw new IOException("could not load images from stream: " + baos.toString());
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            is.close();
        }
    }

    @Transformer(sourceTypes={String.class, InputStream.class, InputSource.class})
    public AuthToken xmlToAuthToken(Document doc, JAXBContext context) throws JAXBException {
        return (AuthToken)context.createUnmarshaller().unmarshal(IBeansSupport.selectOne((String)"/rsp/auth", (Node)doc));
    }

    @Transformer
    public URL transformStringToURL(String string) throws MalformedURLException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException(e.getMessage() + " " + string);
        }
    }
}

