/*
 * Decompiled with CFR 0.152.
 */
package ibeans.client;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.core.XTemplate;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.EditorGrid;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.RowExpander;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import ibeans.client.ClientIBeansException;
import ibeans.client.IBeansCentralPanel;
import ibeans.client.IBeansCentralServiceAsync;
import ibeans.client.IBeansConsole2;
import ibeans.client.Status;
import ibeans.client.model.PluginData;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBeansCentralPanel
extends LayoutContainer {
    private ContentPanel panel;
    private IBeansConsole2 iBeansConsole;
    private Grid<PluginData> grid;

    public IBeansCentralPanel(IBeansConsole2 iBeansConsole) {
        this.iBeansConsole = iBeansConsole;
        this.panel = new ContentPanel();
        this.panel = new ContentPanel();
        this.panel.setAutoHeight(true);
        this.panel.setBodyBorder(false);
        this.panel.setHeaderVisible(true);
        this.panel.setLayout((Layout)new FitLayout());
        this.panel.setAutoWidth(true);
        this.setLayout((Layout)new FlowLayout());
    }

    protected void onRender(Element parent, int index) {
        super.onRender(parent, index);
        this.setLayout((Layout)new FlowLayout(10));
        this.createGrid();
        this.add((Component)this.panel);
    }

    protected void loadData(ListStore<PluginData> store) throws ClientIBeansException {
        IBeansCentralServiceAsync service = this.iBeansConsole.getRepositoryService();
        service.getAvailableIBeans((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createGrid() {
        ListStore store = new ListStore();
        try {
            this.loadData(store);
        }
        catch (ClientIBeansException e) {
            this.iBeansConsole.updateStatus(Status.ERROR, "Failed to load data from the iBeans Store: " + e.getMessage());
        }
        ArrayList<Object> configs = new ArrayList<Object>();
        GridSelectionModel sm = new GridSelectionModel();
        String template = "<table cellpadding='10' cellspacing='10'><tr>\n    <td rowspan=\"3\" valign=\"top\" width=\"58\"><img src=\"images/{type}.jpg\" height=\"54\" width=\"58\"></td>\n    <td width='*' colspan='2'>{description}</td>\n  </tr><tr><td><b>Author: </b><a href='${authorUrl}' target='_blank'>{author}</a></td><td></td></tr><tr><td><b>URL:</b> <a href='{url}' target='_blank'>{url}</a></td><td> </td></tr><tr><td></td><td><b>License:<b> <a href='{licenseUrl}' target='_blank'>{licenseName}</a></td><td></td></tr></table>";
        XTemplate tpl = XTemplate.create((String)template);
        RowExpander expander = new RowExpander(tpl);
        configs.add(expander);
        ColumnConfig column = new ColumnConfig();
        column.setId("name");
        column.setHeader("Name");
        column.setWidth(100);
        configs.add(column);
        column = new ColumnConfig("type", "Type", 100);
        configs.add(column);
        column = new ColumnConfig("version", "Version", 100);
        configs.add(column);
        2 buttonRenderer = new /* Unavailable Anonymous Inner Class!! */;
        column = new ColumnConfig("downloadUrl", "Get it!", 100);
        column.setRenderer((GridCellRenderer)buttonRenderer);
        column.setAlignment(Style.HorizontalAlignment.CENTER);
        configs.add(column);
        ColumnModel cm = new ColumnModel(configs);
        ContentPanel cp = new ContentPanel();
        cp.setHeading("List of iBeans  Available in iBeans Central.");
        cp.setFrame(true);
        cp.setLayout((Layout)new FitLayout());
        cp.setAutoWidth(true);
        cp.setAutoHeight(true);
        this.grid = new EditorGrid(store, cm);
        this.grid.setSelectionModel(sm);
        this.grid.setBorders(true);
        this.grid.addPlugin((ComponentPlugin)expander);
        this.grid.setSelectionModel(sm);
        this.grid.setAutoWidth(true);
        this.grid.setHeight(300);
        this.grid.getView().setAutoFill(true);
        cp.add((Widget)this.grid);
        this.panel.add((Widget)cp);
    }

    static /* synthetic */ IBeansConsole2 access$000(IBeansCentralPanel x0) {
        return x0.iBeansConsole;
    }
}

