/*
 * Decompiled with CFR 0.152.
 */
package ibeans.client;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Viewport;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import ibeans.client.ApplicationService;
import ibeans.client.ApplicationServiceAsync;
import ibeans.client.ExamplesPanel;
import ibeans.client.HTMLDialog;
import ibeans.client.IBeansCentralPanel;
import ibeans.client.IBeansCentralService;
import ibeans.client.IBeansCentralServiceAsync;
import ibeans.client.IBeansConsole2;
import ibeans.client.InstalledPluginsPanel;
import ibeans.client.PluginsService;
import ibeans.client.PluginsServiceAsync;
import ibeans.client.Status;
import ibeans.client.StatusPanel;
import ibeans.client.model.AppInfo;
import ibeans.client.util.ExternalHyperlink;
import ibeans.client.util.InlineFlowPanel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IBeansConsole2
implements EntryPoint {
    private InlineFlowPanel rightHeaderPanel;
    private PluginsServiceAsync pluginsService;
    private IBeansCentralServiceAsync repositoryService;
    private ApplicationServiceAsync applicationService;
    protected TabPanel tabPanel;
    protected Viewport base;
    protected Label product;
    protected FlowPanel footerPanel;
    private ContentPanel centerPanel;
    private List<StatusItem> statusList = new ArrayList();
    private StatusPanel statusBar;
    private UserInfo user;
    private AppInfo appInfo;

    public void onModuleLoad() {
        this.pluginsService = (PluginsServiceAsync)GWT.create(PluginsService.class);
        this.repositoryService = (IBeansCentralServiceAsync)GWT.create(IBeansCentralService.class);
        this.applicationService = (ApplicationServiceAsync)GWT.create(ApplicationService.class);
        ServiceDefTarget target = (ServiceDefTarget)this.pluginsService;
        String baseUrl = "/ibeans/ibeans.Console/";
        target.setServiceEntryPoint(baseUrl + "PluginsService");
        target = (ServiceDefTarget)this.repositoryService;
        target.setServiceEntryPoint(baseUrl + "IBeansCentralService");
        target = (ServiceDefTarget)this.applicationService;
        target.setServiceEntryPoint(baseUrl + "ApplicationService");
        GXT.BLANK_IMAGE_URL = "gxt/images/default/s.gif";
        Image.prefetch((String)"images/lightbox.png");
        this.applicationService.getApplicationInfo((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void initView() {
        this.user = this.getUserInfo();
        this.base = new Viewport();
        this.base.setLayout((Layout)new BorderLayout());
        this.createHeader(null);
        this.tabPanel = new TabPanel();
        this.tabPanel.setAutoHeight(true);
        this.tabPanel.setBodyBorder(false);
        this.tabPanel.setAutoWidth(true);
        this.createBody();
        this.loadTabs(this);
        this.createFooter();
        RootPanel.get().add((Widget)this.base);
        this.base.layout(true);
        this.updateStatus(Status.INFO, "Ready for action");
    }

    public PluginsServiceAsync getPluginsService() {
        return this.pluginsService;
    }

    public IBeansCentralServiceAsync getRepositoryService() {
        return this.repositoryService;
    }

    public ApplicationServiceAsync getApplicationService() {
        return this.applicationService;
    }

    public void updateStatus(Status status, String text) {
        switch (7.$SwitchMap$ibeans$client$Status[status.ordinal()]) {
            case 1: {
                this.statusBar.setInfo(text);
                break;
            }
            case 2: {
                this.statusBar.setInfo(text);
                break;
            }
            case 3: {
                this.statusBar.setWarning(text);
                break;
            }
            case 4: {
                this.statusBar.setError(text);
                break;
            }
            default: {
                this.statusBar.setInfo(text);
            }
        }
        this.statusList.add(new StatusItem(this, this.statusBar.getCurrentIconStyle(), text, null));
    }

    public void errorStatus(Throwable t) {
        if (t.getMessage().startsWith("<")) {
            new HTMLDialog("Server Error", t.getMessage()).show();
            this.updateStatus(Status.ERROR, "Server Error, see log:  (" + t.getClass().getName() + ")");
        } else {
            this.updateStatus(Status.ERROR, t.getMessage() + " (" + t.getClass().getName() + ")");
        }
    }

    private void createFooter() {
        ContentPanel southPanel = new ContentPanel();
        southPanel.setBorders(false);
        southPanel.setHeaderVisible(false);
        BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.SOUTH, 60.0f);
        data.setMargins(new Margins());
        this.footerPanel = new FlowPanel();
        this.footerPanel.setStyleName("footer");
        this.statusBar = new StatusPanel();
        this.footerPanel.add((Widget)this.statusBar);
        InlineFlowPanel bottom = new InlineFlowPanel();
        this.footerPanel.add((Widget)bottom);
        this.prependFooterConent((FlowPanel)bottom);
        southPanel.add((Widget)this.footerPanel);
        this.base.add((Widget)southPanel, (LayoutData)data);
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    protected void prependFooterConent(FlowPanel panel) {
        this.product = new Label("About " + this.appInfo.getName());
        this.product.setStyleName("footer-link");
        this.product.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        panel.add((Widget)this.product);
        panel.add((Widget)this.newSpacerPipe());
        Label copyright = new Label(this.appInfo.getCopyright());
        panel.add((Widget)copyright);
    }

    public Label newSpacerPipe() {
        Label pipe = new Label(" | ");
        pipe.setStyleName("pipe-with-space");
        return pipe;
    }

    protected void createHeader(Image logo) {
        ContentPanel northPanel = new ContentPanel();
        northPanel.setBorders(false);
        northPanel.setHeaderVisible(false);
        BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.NORTH, 33.0f);
        data.setMargins(new Margins());
        data.setSize(50.0f);
        this.rightHeaderPanel = new InlineFlowPanel();
        this.rightHeaderPanel.setStyleName("header-right");
        this.rightHeaderPanel.add((Widget)this.createHeaderOptions());
        FlowPanel header = new FlowPanel();
        header.setStyleName("header");
        header.add((Widget)this.rightHeaderPanel);
        northPanel.add((Widget)header);
        this.base.add((Widget)northPanel, (LayoutData)data);
        Label head = new Label(this.appInfo.getName());
        head.setStyleName("header-title");
        header.add((Widget)head);
        Label subhead = new Label(this.appInfo.getVersion());
        subhead.setStyleName("header-sub-title");
        header.add((Widget)subhead);
    }

    protected InlineFlowPanel createHeaderOptions() {
        InlineFlowPanel options = new InlineFlowPanel();
        options.setStyleName("header-right-options");
        if (this.user.getUser() != null) {
            Label l = new Label("Welcome, " + this.user.getUser());
            options.add((Widget)l);
            options.add((Widget)this.newSpacerPipe());
            Label l2 = new Label("Log Out");
            l2.setStyleName("faux-link");
            options.add((Widget)l2);
            l2.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            Label l = new Label("Log In");
            l.setStyleName("faux-link");
            l.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            options.add((Widget)l);
        }
        options.add((Widget)this.newSpacerPipe());
        options.add((Widget)new ExternalHyperlink("Help", "http://www.mulesoft.org/display/IBEANS/Managing+iBeans", "_blank"));
        return options;
    }

    protected void createBody() {
        this.centerPanel = new ContentPanel();
        this.centerPanel.setBorders(false);
        this.centerPanel.setHeaderVisible(false);
        this.centerPanel.setScrollMode(Style.Scroll.NONE);
        this.centerPanel.setLayout((Layout)new FlowLayout());
        this.centerPanel.add((Widget)this.tabPanel);
        BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.CENTER);
        data.setMargins(new Margins());
        this.base.add((Widget)this.centerPanel, (LayoutData)data);
    }

    protected void loadTabs(IBeansConsole2 console) {
        if (this.user.isShowWelcome()) {
            TabItem welcomeTab = new TabItem();
            welcomeTab.setText("Welcome");
            welcomeTab.setScrollMode(Style.Scroll.AUTOX);
            RequestBuilder req = new RequestBuilder(RequestBuilder.GET, GWT.getHostPageBaseURL() + "welcome-beta.html");
            req.setCallback((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
            try {
                req.send();
            }
            catch (RequestException e) {
                this.errorStatus((Throwable)e);
            }
            this.tabPanel.add(welcomeTab);
        }
        TabItem configTab = new TabItem();
        configTab.setText("Configure");
        configTab.setLayout((Layout)new FlowLayout());
        configTab.add((Widget)new InstalledPluginsPanel(console));
        configTab.layout();
        TabItem storeTab = new TabItem();
        storeTab.setText("iBeans Central");
        storeTab.add((Widget)new IBeansCentralPanel(console));
        TabItem examplesTab = new TabItem();
        examplesTab.setText("Examples");
        examplesTab.add((Widget)new ExamplesPanel(console));
        this.tabPanel.add(examplesTab);
        this.tabPanel.add(configTab);
        this.tabPanel.add(storeTab);
    }

    protected TabItem createEmptyTab(String name, String toolTip) {
        TabItem tab = new TabItem();
        TabItem.HeaderItem header = tab.getHeader();
        header.setText(name);
        if (toolTip != null) {
            header.setToolTip(toolTip);
        }
        tab.setLayout((Layout)new FlowLayout());
        return tab;
    }

    protected TabItem createEmptyTab(String name) {
        return this.createEmptyTab(name, null);
    }

    UserInfo getUserInfo() {
        if (this.user == null) {
            String rawCookie = Cookies.getCookie((String)"ibeans-console");
            if (rawCookie.equals("")) {
                UserInfo info = new UserInfo(this);
                return info;
            }
            return new UserInfo(this, rawCookie);
        }
        return this.user;
    }

    void saveUserInfo(UserInfo info) {
        if (info.getUser() != null) {
            this.getRepositoryService().verifyUser(info.getUser(), info.getPass(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.doSaveUser(info);
        }
    }

    private void doSaveUser(UserInfo info) {
        Date now = new Date();
        now.setYear(now.getYear() + 1);
        Cookies.setCookie((String)"ibeans-console", (String)info.toString(), (Date)now);
        this.user = info;
        this.rightHeaderPanel.remove(0);
        this.rightHeaderPanel.add((Widget)this.createHeaderOptions());
    }

    void clearUserInfo() {
        this.saveUserInfo(new UserInfo(this));
    }

    static /* synthetic */ AppInfo access$002(IBeansConsole2 x0, AppInfo x1) {
        x0.appInfo = x1;
        return x0.appInfo;
    }

    static /* synthetic */ InlineFlowPanel access$200(IBeansConsole2 x0) {
        return x0.rightHeaderPanel;
    }

    static /* synthetic */ void access$300(IBeansConsole2 x0, UserInfo x1) {
        x0.doSaveUser(x1);
    }
}

