/*
 * Decompiled with CFR 0.152.
 */
package ibeans.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import ibeans.client.ClientIBeansException;
import ibeans.client.IBeansCentralService;
import ibeans.client.model.Plugin;
import ibeans.server.PluginsServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import org.ibeans.api.CallException;
import org.mule.ibeans.IBeansContext;
import org.mule.ibeans.ibeanscentral.IBeanInfo;
import org.mule.ibeans.ibeanscentral.IbeansCentralIBean;
import org.mule.ibeans.internal.config.IBeansInfo;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBeansCentralServiceImpl
extends RemoteServiceServlet
implements IBeansCentralService {
    private IbeansCentralIBean ibeansCentral;
    private IBeansContext iBeansContext;
    private File deployedIbeans;
    private Properties props = new Properties();

    public void init() throws ServletException {
        super.init();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("ibeans.properties");
        if (is == null) {
            throw new ServletException("Could not load 'ibeans.properites' from the classpath. Make sure this file is present in IBEANS_HOME/conf");
        }
        this.props = new Properties();
        try {
            this.props.load(is);
        }
        catch (IOException e) {
            throw new ServletException("failed to read 'ibeans.properties'", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        String catalinaHome = this.getServletConfig().getInitParameter("catalina.home");
        if (catalinaHome == null) {
            catalinaHome = System.getProperty("catalina.home");
        }
        if (catalinaHome == null) {
            throw new ServletException("The catalina.home property is not set that defines the home directory for Tomcat.  Set it either as an init parameter on PluginsServiceImpl servlet or as a system property");
        }
        String ibeansPath = catalinaHome + PluginsServiceImpl.IBEANS_BASE_NAME + "ibeans" + File.separator + "deployed";
        this.deployedIbeans = new File(ibeansPath);
        if (!this.deployedIbeans.exists()) {
            throw new ServletException("Could not find Mule iBeans directory: " + ibeansPath + ". Make sure you have the catalina.home set or pass in the home path when running this util");
        }
        this.iBeansContext = (IBeansContext)this.getServletContext().getAttribute("mule.ibeans.context");
        this.ibeansCentral = (IbeansCentralIBean)this.iBeansContext.createIBean(IbeansCentralIBean.class);
        this.ibeansCentral.setCredentials(this.props.getProperty("ibeans.central.username"), this.props.getProperty("ibeans.central.password"));
    }

    public List<Plugin> getAvailableIBeans() throws ClientIBeansException {
        try {
            List ibeans = this.ibeansCentral.getIBeans(IBeansInfo.getProductVersion());
            ArrayList<Plugin> plugins = new ArrayList<Plugin>(ibeans.size());
            for (IBeanInfo ibean : ibeans) {
                plugins.add(this.createPlugIn(ibean));
            }
            return plugins;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClientIBeansException(e.getMessage());
        }
    }

    protected Plugin createPlugIn(IBeanInfo info) throws CallException {
        Plugin p = new Plugin(info.getShortName(), info.getName(), info.getDescription(), info.getVersion(), "iBean");
        p.setAuthor(info.getAuthorName());
        p.setAuthorUrl(info.getAuthorUrl());
        p.setLicenseName(info.getLicenseName());
        p.setLicenseUrl(info.getLicenseUrl());
        p.setUrl(info.getUrl());
        return p;
    }

    public String downloadIBean(String user, String pass, String id, String version) throws ClientIBeansException {
        IBeanInfo ibean;
        InputStream in;
        FileOutputStream out;
        block7: {
            IbeansCentralIBean userIbeansCentral = (IbeansCentralIBean)this.iBeansContext.createIBean(IbeansCentralIBean.class);
            userIbeansCentral.setCredentials(user, pass);
            out = null;
            in = null;
            ibean = userIbeansCentral.getIBeanByShortName(id, version);
            if (ibean == null) {
                throw new ClientIBeansException("iBean  not found: " + id + "(" + version + ")");
            }
            in = userIbeansCentral.downloadIBean(ibean.getDownloadUri());
            if (in == null) break block7;
            File file = new File(this.deployedIbeans, ibean.getFullFileName());
            out = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            String string = "The ibean has been downloaded to: " + file;
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            return string;
        }
        try {
            try {
                throw new ClientIBeansException("Failed to download ibean from: " + ibean.getDownloadUri());
            }
            catch (ClientIBeansException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ClientIBeansException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
    }

    public Boolean verifyUser(String user, String password) throws ClientIBeansException {
        IbeansCentralIBean userIbeansCentral = (IbeansCentralIBean)this.iBeansContext.createIBean(IbeansCentralIBean.class);
        try {
            return userIbeansCentral.verifyCredentials(user, password);
        }
        catch (CallException e) {
            throw new ClientIBeansException(e.getMessage());
        }
    }
}

