/*
 * Decompiled with CFR 0.152.
 */
package ibeans.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MavenPomReader {
    Document doc;
    XPathExpression nameExpression;
    XPathExpression descriptionExpression;
    XPathExpression versionExpression;
    XPathExpression urlExpression;
    XPathExpression organizationExpression;
    XPathExpression authorExpression;
    XPathExpression licenseNameExpression;
    XPathExpression licenseUrlExpression;
    XPathExpression bundledExpression;
    XPathExpression requiredExpression;

    public MavenPomReader(InputStream is) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        this.init(doc);
    }

    public MavenPomReader(File file) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        this.init(doc);
    }

    private void init(Document doc) throws XPathExpressionException {
        this.doc = doc;
        this.nameExpression = XPathFactory.newInstance().newXPath().compile("/project/name");
        this.descriptionExpression = XPathFactory.newInstance().newXPath().compile("/project/description");
        this.versionExpression = XPathFactory.newInstance().newXPath().compile("/project/version");
        this.urlExpression = XPathFactory.newInstance().newXPath().compile("/project/url");
        this.organizationExpression = XPathFactory.newInstance().newXPath().compile("/project/organization/name");
        this.authorExpression = XPathFactory.newInstance().newXPath().compile("/project/developers/developer/name");
        this.licenseNameExpression = XPathFactory.newInstance().newXPath().compile("/project/licenses/license/name");
        this.licenseUrlExpression = XPathFactory.newInstance().newXPath().compile("/project/licenses/license/url");
        this.bundledExpression = XPathFactory.newInstance().newXPath().compile("/project/properties/bundled");
        this.requiredExpression = XPathFactory.newInstance().newXPath().compile("/project/properties/required");
    }

    public String getName() {
        return this.eval(this.nameExpression);
    }

    public String getVersion() {
        return this.eval(this.versionExpression);
    }

    public String getDescription() {
        return this.eval(this.descriptionExpression);
    }

    public String getUrl() {
        return this.eval(this.urlExpression);
    }

    public String getOrganization() {
        return this.eval(this.organizationExpression);
    }

    public String getAuthor() {
        String author = this.eval(this.authorExpression);
        author = author == null ? this.getOrganization() : author + ", " + this.getOrganization();
        return author;
    }

    public boolean isBundled() {
        return "TRUE".equalsIgnoreCase(this.eval(this.bundledExpression));
    }

    public boolean isRequired() {
        return "TRUE".equalsIgnoreCase(this.eval(this.requiredExpression));
    }

    public String getLicenseName() {
        return this.eval(this.licenseNameExpression);
    }

    public String getLicenseUrl() {
        return this.eval(this.licenseUrlExpression);
    }

    protected String eval(XPathExpression exp) {
        try {
            return exp.evaluate(this.doc);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }
}

