/*
 * Decompiled with CFR 0.152.
 */
package ibeans.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import ibeans.client.ClientIBeansException;
import ibeans.client.PluginsService;
import ibeans.client.model.Plugin;
import ibeans.server.MavenPomReader;
import ibeans.server.PluginsServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletException;
import org.mule.ibeans.internal.config.IBeansInfo;
import org.mule.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsServiceImpl
extends RemoteServiceServlet
implements PluginsService {
    public static final String DEPLOYED_NAME = "deployed";
    public static final String NOT_DEPLOYED_NAME = "notdeployed";
    public static final String MODULES_NAME = "modules";
    public static final String IBEANS_NAME = "ibeans";
    public static final String IBEANS_HOME = File.separator + "mule-ibeans";
    public static final String IBEANS_BASE_NAME = IBEANS_HOME + File.separator + "lib" + File.separator;
    private String catalinaHome;
    private File modules;
    private File ibeans;
    private File webapps;

    public void init() throws ServletException {
        super.init();
        this.catalinaHome = this.getServletConfig().getInitParameter("catalina.home");
        if (this.catalinaHome == null) {
            this.catalinaHome = System.getProperty("catalina.home");
        }
        if (this.catalinaHome == null) {
            throw new ServletException("The catalina.home property is not set that defines the home directory for Tomcat.  Set it either as an init parameter on PluginsServiceImpl servlet or as a system property");
        }
        String modulesPath = this.catalinaHome + IBEANS_BASE_NAME + MODULES_NAME;
        String ibeansPath = this.catalinaHome + IBEANS_BASE_NAME + IBEANS_NAME;
        this.modules = new File(modulesPath);
        this.ibeans = new File(ibeansPath);
        this.webapps = new File(this.catalinaHome + IBEANS_HOME + File.separator + "webapps");
        if (!this.modules.exists()) {
            throw new ServletException("Could not find Mule iBeans modules: " + modulesPath + ". Make sure you have the catalina.home set or pass in the home path when running this util");
        }
        if (!this.ibeans.exists()) {
            throw new ServletException("Could not find Mule iBeans directory: " + ibeansPath + ". Make sure you have the catalina.home set or pass in the home path when running this util");
        }
        if (!this.webapps.exists()) {
            throw new ServletException("Could not find Mule iBeans directory: " + this.webapps.getAbsolutePath() + ". Make sure you have the catalina.home set or pass in the home path when running this util");
        }
    }

    public List<Plugin> getInstalledPlugins() throws ClientIBeansException {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        this.readLibDirectory(new File(this.ibeans, DEPLOYED_NAME), plugins, "iBean");
        this.readLibDirectory(new File(this.ibeans, NOT_DEPLOYED_NAME), plugins, "iBean");
        this.readLibDirectory(new File(this.modules, DEPLOYED_NAME), plugins, "Module");
        this.readLibDirectory(new File(this.modules, NOT_DEPLOYED_NAME), plugins, "Module");
        this.readWebAppPlugins(plugins);
        return plugins;
    }

    public List<Plugin> getRunningWebapps() throws ClientIBeansException {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        this.readWebappsDirectory(new File(this.catalinaHome, "webapps"), plugins, WebAppType.EXPLODED);
        return plugins;
    }

    protected void readWebAppPlugins(List<Plugin> plugins) throws ClientIBeansException {
        ArrayList deployed = new ArrayList();
        ArrayList all = new ArrayList();
        this.readWebappsDirectory(new File(this.catalinaHome, "webapps"), deployed, WebAppType.EXPLODED);
        this.readWebappsDirectory(this.webapps, all, WebAppType.WAR);
        for (Plugin plugin : all) {
            plugin.setEnabled(deployed.contains(plugin));
        }
        plugins.addAll(all);
    }

    protected List<Plugin> readWebappsDirectory(File dir, List<Plugin> plugins, WebAppType webAppType) throws ClientIBeansException {
        File[] warsDirs = dir.listFiles();
        for (int i = 0; i < warsDirs.length; ++i) {
            if (!warsDirs[i].isDirectory() && webAppType == WebAppType.EXPLODED || !warsDirs[i].getName().endsWith(".war") && webAppType == WebAppType.WAR) continue;
            try {
                Plugin p = this.createWar(warsDirs[i]);
                if (p == null) continue;
                plugins.add(p);
                continue;
            }
            catch (IOException e) {
                this.log("Failed to read ibean: " + warsDirs[i].getAbsolutePath(), (Throwable)e);
            }
        }
        return plugins;
    }

    protected void readLibDirectory(File dir, List<Plugin> plugins, String type) {
        File[] ibeanJars = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < ibeanJars.length; ++i) {
            File file = ibeanJars[i];
            try {
                plugins.add(this.createPluginData(file, type));
                continue;
            }
            catch (Throwable t) {
                this.log("Failed to read ibean: " + file.getAbsolutePath(), t);
            }
        }
    }

    protected void readModulesDirectory(File dir, List<Plugin> plugins) throws ClientIBeansException {
        File[] fileModules = dir.listFiles();
        for (int i = 0; i < fileModules.length; ++i) {
            File fileModule = fileModules[i];
            if (!fileModule.isDirectory()) continue;
            try {
                plugins.add(this.createModule(fileModule));
                continue;
            }
            catch (ClientIBeansException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientIBeansException("Failed to read modules: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updatePlugins(List<Plugin> plugins) throws ClientIBeansException {
        for (Plugin plugin : plugins) {
            File notdeployedLocation;
            File deployedLocation;
            if (plugin.getType().equals("WebApp")) {
                deployedLocation = new File(this.catalinaHome, "webapps");
                notdeployedLocation = this.webapps;
                File warFile = new File(deployedLocation, plugin.getFilename());
                if (!plugin.isEnabled()) {
                    FileUtils.deleteTree((File)new File(deployedLocation, plugin.getId()));
                    FileUtils.deleteQuietly((File)warFile);
                    continue;
                }
                if (warFile.exists()) continue;
                try {
                    FileUtils.copyFile((File)new File(this.webapps, plugin.getFilename()), (File)warFile);
                    continue;
                }
                catch (IOException e) {
                    throw new ClientIBeansException((Throwable)e);
                }
            }
            if (plugin.getType().equals("iBean")) {
                deployedLocation = new File(new File(this.ibeans, DEPLOYED_NAME), plugin.getFilename());
                notdeployedLocation = new File(new File(this.ibeans, NOT_DEPLOYED_NAME), plugin.getFilename());
            } else {
                deployedLocation = new File(new File(this.modules, DEPLOYED_NAME), plugin.getId());
                notdeployedLocation = new File(new File(this.modules, NOT_DEPLOYED_NAME), plugin.getId());
            }
            if (!plugin.isEnabled() && deployedLocation.exists()) {
                this.movePlugin(plugin, deployedLocation, notdeployedLocation);
                continue;
            }
            if (!plugin.isEnabled() || !notdeployedLocation.exists()) continue;
            this.movePlugin(plugin, notdeployedLocation, deployedLocation);
        }
    }

    protected void movePlugin(Plugin plugin, File from, File to) throws ClientIBeansException {
        if (!from.renameTo(to)) {
            throw new ClientIBeansException("Failed module '" + plugin.getName() + "' from '" + from.getPath() + "' to '" + to.getPath() + "'. Contact you're administrator to check file permissions.");
        }
        this.log("Moved module '" + plugin.getName() + "' from '" + from.getAbsolutePath() + "' to '" + to.getAbsolutePath() + "'");
    }

    protected Plugin createModule(File dir) throws Exception {
        File[] mod = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (mod.length == 1) {
            MavenPomReader reader = new MavenPomReader(mod[0]);
            Plugin plugin = new Plugin();
            plugin.setId(dir.getName());
            plugin.setName(reader.getName());
            plugin.setDescription(reader.getDescription());
            plugin.setVersion(reader.getVersion());
            plugin.setUrl(reader.getUrl());
            plugin.setAuthor(reader.getOrganization());
            plugin.setInstalled(true);
            plugin.setType("Module");
            plugin.setEnabled(!dir.getAbsolutePath().contains(NOT_DEPLOYED_NAME));
            plugin.setLicenseName(reader.getLicenseName());
            plugin.setLicenseUrl(reader.getLicenseUrl());
            plugin.setBundled(reader.isBundled());
            plugin.setRequired(reader.isRequired());
            if ((plugin.getVersion() == null || plugin.getVersion().length() == 0) && plugin.isBundled()) {
                plugin.setVersion(IBeansInfo.getProductVersion());
            }
            return plugin;
        }
        Plugin plugin = new Plugin();
        plugin.setId(dir.getName());
        plugin.setName(plugin.getId().substring(0, 1).toUpperCase() + plugin.getId().substring(1));
        plugin.setDescription("No module descriptor available");
        plugin.setInstalled(true);
        plugin.setType("Module");
        plugin.setEnabled(!dir.getAbsolutePath().contains(NOT_DEPLOYED_NAME));
        plugin.setWarning("There is no module descriptor for '" + plugin.getName() + "'");
        return plugin;
    }

    protected Plugin createPluginData(File jar, String type) throws IOException {
        Plugin plugin = new Plugin();
        JarFile file = new JarFile(jar);
        Manifest manifest = file.getManifest();
        plugin.setName(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE));
        String name = plugin.getName();
        if (name != null && name.length() > 0) {
            plugin.setId(name.substring(0, name.indexOf(" ")).toLowerCase());
        } else {
            plugin.setId(jar.getName());
        }
        plugin.setDescription(manifest.getMainAttributes().getValue("Product-Description"));
        plugin.setVersion(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        plugin.setUrl(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_URL));
        plugin.setInstalled(true);
        plugin.setType(type);
        plugin.setEnabled(!jar.getAbsolutePath().contains(NOT_DEPLOYED_NAME));
        plugin.setFilename(jar.getName());
        String artifact = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE);
        String groupID = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
        JarEntry pom = file.getJarEntry("META-INF/maven/" + groupID + "/" + artifact + "/pom.xml");
        if (pom != null) {
            InputStream is = file.getInputStream(pom);
            try {
                MavenPomReader reader = new MavenPomReader(is);
                plugin.setAuthor(reader.getOrganization());
                plugin.setLicenseName(reader.getLicenseName());
                plugin.setLicenseUrl(reader.getLicenseUrl());
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plugin createWar(File war) throws IOException {
        FileInputStream fis = null;
        try {
            Manifest manifest;
            if (war.isDirectory()) {
                File file = new File(war, "/META-INF/MANIFEST.MF");
                if (!file.exists()) {
                    Plugin plugin = null;
                    return plugin;
                }
                fis = new FileInputStream(file);
                manifest = new Manifest(fis);
            } else {
                JarFile warFile = new JarFile(war);
                manifest = warFile.getManifest();
                if (manifest == null) {
                    Plugin plugin = null;
                    return plugin;
                }
            }
            Plugin plugin = new Plugin();
            plugin.setName(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE));
            if (plugin.getName() == null) {
                Plugin plugin2 = null;
                return plugin2;
            }
            plugin.setId(war.getName().replace(".war", ""));
            plugin.setDescription(manifest.getMainAttributes().getValue("Product-Description"));
            plugin.setFurtherInfo(manifest.getMainAttributes().getValue("Further-Info"));
            plugin.setVersion(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION));
            plugin.setUrl(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_URL));
            plugin.setInstalled(true);
            plugin.setType("WebApp");
            plugin.setEnabled(true);
            plugin.setFilename(war.getName().endsWith(".war") ? war.getName() : war.getName() + ".war");
            Plugin plugin3 = plugin;
            return plugin3;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

