/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.web.jabsorb;

import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 773727271L;
    private static Class<?>[] _JSONClasses = new Class[]{String.class};
    private static Class<?>[] _serializableClasses = new Class[0];

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return clazz.isEnum();
    }

    public Class<?>[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class<?>[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        if (o instanceof Enum) {
            return o.toString();
        }
        return null;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class aClass, Object json) throws UnmarshallException {
        Class<?>[] classes = json.getClass().getClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].isEnum()) continue;
            state.setSerialized(json, (Object)ObjectMatch.OKAY);
            return ObjectMatch.OKAY;
        }
        state.setSerialized(json, (Object)ObjectMatch.SIMILAR);
        return ObjectMatch.SIMILAR;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object json) throws UnmarshallException {
        String val = json.toString();
        if (clazz.isEnum()) {
            try {
                return Enum.valueOf(clazz, val);
            }
            catch (Exception e) {
                return Enum.valueOf(clazz, val.toUpperCase());
            }
        }
        return null;
    }
}

