/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.module.guice;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import org.mule.util.pool.CommonsPoolObjectPool;

public class MuleScopes {
    private static Scope POOLED = new PooledScope();

    public static Scope pooledScope(int size, PooledScope.INIT_POLICY initPolicy, PooledScope.EXHAUSTED_POLICY exhaustedPolicy) {
        return new PooledScope(size, initPolicy, exhaustedPolicy);
    }

    public static Scope pooledScope() {
        return POOLED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PooledScope
    implements Scope {
        private int size = 10;
        private INIT_POLICY initPolicy = INIT_POLICY.InitialiseOne;
        private EXHAUSTED_POLICY exhaustedPolicy = EXHAUSTED_POLICY.Grow;
        private CommonsPoolObjectPool pool;

        private PooledScope() {
        }

        private PooledScope(int size, INIT_POLICY initPolicy, EXHAUSTED_POLICY exhaustedPolicy) {
            this.size = size;
            this.initPolicy = initPolicy;
            this.exhaustedPolicy = exhaustedPolicy;
        }

        public <T> Provider<T> scope(Key<T> tKey, Provider<T> creator) {
            return creator;
        }

        public String toString() {
            return "MuleScopes.POOLED";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PooledScope that = (PooledScope)o;
            return this.size == that.size && this.exhaustedPolicy == that.exhaustedPolicy && this.initPolicy == that.initPolicy;
        }

        public int hashCode() {
            int result = this.size;
            result = 31 * result + (this.initPolicy != null ? this.initPolicy.hashCode() : 0);
            result = 31 * result + (this.exhaustedPolicy != null ? this.exhaustedPolicy.hashCode() : 0);
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EXHAUSTED_POLICY {
            Wait,
            Fail,
            Grow;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum INIT_POLICY {
            InitialiseOne,
            InitialiseAll;

        }
    }
}

