/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.spring;

import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.service.Service;
import org.mule.ibeans.IBeansContext;
import org.mule.module.annotationx.jsr330.InjectAnnotationProcessor;
import org.mule.module.annotationx.parsers.AnnotatedServiceObjectProcessor;
import org.mule.module.ibeans.config.IntegrationBeanAnnotatedObjectProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class IBeanInjectorsBeanPostProcessor
implements BeanPostProcessor {
    private InjectAnnotationProcessor injectDelegate;
    private AnnotatedServiceObjectProcessor applicationAnnotationsProcessor;
    private IntegrationBeanAnnotatedObjectProcessor ibeanAnnotationProcessor;
    private MuleContext muleContext;

    public IBeanInjectorsBeanPostProcessor(MuleContext context) {
        this.muleContext = context;
        this.injectDelegate = new InjectAnnotationProcessor(this.muleContext);
        this.applicationAnnotationsProcessor = new AnnotatedServiceObjectProcessor(this.muleContext);
        this.ibeanAnnotationProcessor = new IntegrationBeanAnnotatedObjectProcessor(this.muleContext);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        bean = this.ibeanAnnotationProcessor.process(bean);
        Object service = this.applicationAnnotationsProcessor.process(bean = this.injectDelegate.process(bean));
        if (service instanceof Service) {
            try {
                this.muleContext.getRegistry().registerService((Service)service);
            }
            catch (MuleException e) {
                throw new BeanCreationException("Failed to register iBeans service", (Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beans = applicationContext.getBeansOfType(IBeansContext.class);
        IBeansContext ctx = (IBeansContext)beans.values().iterator().next();
        this.muleContext = (MuleContext)ctx.getConfig().get(MuleContext.class.getName());
        this.injectDelegate = new InjectAnnotationProcessor(this.muleContext);
        this.applicationAnnotationsProcessor = new AnnotatedServiceObjectProcessor(this.muleContext);
    }
}

