/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.spring;

import java.util.ArrayList;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.ibeans.IBeansContext;
import org.mule.ibeans.IBeansFactory;
import org.mule.ibeans.config.PropertiesConfigurationBuilder;
import org.mule.ibeans.internal.config.IBeansMuleContextBuilder;
import org.mule.ibeans.internal.config.IBeansMuleContextFactory;
import org.mule.ibeans.internal.config.ShutdownSplash;
import org.mule.ibeans.internal.config.StartupSplash;
import org.mule.ibeans.spring.IBeanInjectorsBeanPostProcessor;
import org.mule.module.ibeans.config.IBeanHolderConfigurationBuilder;
import org.mule.util.SplashScreen;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

public class IBeansContextFactoryBean
extends AbstractFactoryBean
implements InitializingBean,
ApplicationContextAware {
    private String serverId;
    private boolean disableInjectors = false;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Class getObjectType() {
        return IBeansContext.class;
    }

    protected Object createInstance() throws Exception {
        ArrayList<Object> builders = new ArrayList<Object>();
        builders.add(new DefaultsConfigurationBuilder());
        builders.add(new IBeanHolderConfigurationBuilder());
        builders.add(new PropertiesConfigurationBuilder());
        IBeansMuleContextFactory muleContextFactory = new IBeansMuleContextFactory();
        DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
        if (this.getServerId() != null) {
            muleConfiguration.setId(this.getServerId());
        }
        IBeansMuleContextBuilder muleContextBuilder = new IBeansMuleContextBuilder();
        muleContextBuilder.setStartupScreen((SplashScreen)new StartupSplash());
        muleContextBuilder.setShutdownScreen((SplashScreen)new ShutdownSplash());
        muleContextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
        MuleContext mc = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)muleContextBuilder);
        new IBeansFactory().setMuleContext(mc);
        IBeansContext ibc = (IBeansContext)mc.getRegistry().lookupObject(IBeansContext.class);
        if (!this.disableInjectors) {
            if (this.applicationContext instanceof AbstractApplicationContext) {
                ((AbstractAutowireCapableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory()).addBeanPostProcessor((BeanPostProcessor)new IBeanInjectorsBeanPostProcessor(mc));
            } else {
                throw new BeanCreationException("IBean injectors are enabled but the applicationContext being used does not extend AbstractApplicationContext so cannot register post processor");
            }
        }
        return ibc;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public boolean isDisableInjectors() {
        return this.disableInjectors;
    }

    public void setDisableInjectors(boolean disableInjectors) {
        this.disableInjectors = disableInjectors;
    }
}

